/****************************************************************************
**
** This file is part of the Qt Extended Opensource Package.
**
** Copyright (C) 2009 Trolltech ASA.
**
** Contact: Qt Extended Information (info@qtextended.org)
**
** This file may be used under the terms of the GNU General Public License
** version 2.0 as published by the Free Software Foundation and appearing
** in the file LICENSE.GPL included in the packaging of this file.
**
** Please review the following information to ensure GNU General Public
** Licensing requirements will be met:
**     http://www.fsf.org/licensing/licenses/info/GPLv2.html.
**
**
****************************************************************************/
#include "qoutlook.h"

#include <trace.h>
QD_LOG_OPTION(QOutlook)

QDateTime date_to_qdatetime( double date )
{
    TRACE(QOutlook) << "date_to_qdatetime";
    // This appears to be a sentinel value representing "no date"
    if ( date == 949998 ) {
        return QDateTime();
    }
    SYSTEMTIME tm;
    if ( VariantTimeToSystemTime( date, &tm ) == FALSE ) {
        WARNING() << "VariantTimeToSystemTime failed for variant time" << date;
        return QDateTime();
    }
    return QDateTime( QDate(tm.wYear, tm.wMonth, tm.wDay),
                      QTime(tm.wHour, tm.wMinute, tm.wSecond, tm.wMilliseconds) );
}

double qdatetime_to_date( const QDateTime &dt )
{
    TRACE(QOutlook) << "qdatetime_to_date";
    if ( !dt.isValid() ) {
        // This appears to be a sentinel value representing "no date"
        return 949998;
    }
    SYSTEMTIME tm;
    QDate d = dt.date();
    QTime t = dt.time();
    tm.wYear = d.year();
    tm.wMonth = d.month();
    tm.wDay = d.day();
    tm.wHour = t.hour();
    tm.wMinute = t.minute();
    tm.wSecond = t.second();
    tm.wMilliseconds = t.msec();
    double date = 949998;
    if ( SystemTimeToVariantTime( &tm, &date ) == 0 ) {
        LOG() << "SystemTimeToVariantTime failed for QDateTime" << dt << "Sending 949998 (sentinel?)";
    }
    return date;
}

QString bstr_to_qstring( const _bstr_t &string )
{
    return QString::fromUtf16( (unsigned short*)(wchar_t*)string );
}

_bstr_t qstring_to_bstr( const QString &string )
{
    return _bstr_t( (wchar_t*)string.constData() );
}

QString variant_to_qstring( const _variant_t &string )
{
    return bstr_to_qstring( (_bstr_t)string );
}

_variant_t qstring_to_variant( const QString &string )
{
    return _variant_t( qstring_to_bstr(string) );
}

// =====================================================================

#pragma warning(disable:4146)

// This file is generated by the findoutlook utility
#include "qoutlook_detect.cpp"

#pragma warning(default:4146)

