/****************************************************************************
**
** This file is part of the Qt Extended Opensource Package.
**
** Copyright (C) 2009 Trolltech ASA.
**
** Contact: Qt Extended Information (info@qtextended.org)
**
** This file may be used under the terms of the GNU General Public License
** version 2.0 as published by the Free Software Foundation and appearing
** in the file LICENSE.GPL included in the packaging of this file.
**
** Please review the following information to ensure GNU General Public
** Licensing requirements will be met:
**     http://www.fsf.org/licensing/licenses/info/GPLv2.html.
**
**
****************************************************************************/
#define RETURN_PROP_CASE(pt) case PROP_ID(pt): return(QString(#pt))
#define RETURN_CASE(pt) case pt: return(QString(#pt))

static QString hrtext( HRESULT hr )
{
    switch ( hr ) {
        RETURN_CASE(MAPI_E_CALL_FAILED);
        RETURN_CASE(MAPI_E_NOT_ENOUGH_MEMORY);
        RETURN_CASE(MAPI_E_INVALID_PARAMETER);
        RETURN_CASE(MAPI_E_INTERFACE_NOT_SUPPORTED);
        RETURN_CASE(MAPI_E_NO_ACCESS);
        RETURN_CASE(MAPI_E_NO_SUPPORT);
        RETURN_CASE(MAPI_E_BAD_CHARWIDTH);
        RETURN_CASE(MAPI_E_STRING_TOO_LONG);
        RETURN_CASE(MAPI_E_UNKNOWN_FLAGS);
        RETURN_CASE(MAPI_E_INVALID_ENTRYID);
        RETURN_CASE(MAPI_E_INVALID_OBJECT);
        RETURN_CASE(MAPI_E_OBJECT_CHANGED);
        RETURN_CASE(MAPI_E_OBJECT_DELETED);
        RETURN_CASE(MAPI_E_BUSY);
        RETURN_CASE(MAPI_E_NOT_ENOUGH_DISK);
        RETURN_CASE(MAPI_E_NOT_ENOUGH_RESOURCES);
        RETURN_CASE(MAPI_E_NOT_FOUND);
        RETURN_CASE(MAPI_E_VERSION);
        RETURN_CASE(MAPI_E_LOGON_FAILED);
        RETURN_CASE(MAPI_E_SESSION_LIMIT);
        RETURN_CASE(MAPI_E_USER_CANCEL);
        RETURN_CASE(MAPI_E_UNABLE_TO_ABORT);
        RETURN_CASE(MAPI_E_NETWORK_ERROR);
        RETURN_CASE(MAPI_E_DISK_ERROR);
        RETURN_CASE(MAPI_E_TOO_COMPLEX);
        RETURN_CASE(MAPI_E_BAD_COLUMN);
        RETURN_CASE(MAPI_E_EXTENDED_ERROR);
        RETURN_CASE(MAPI_E_COMPUTED);
        RETURN_CASE(MAPI_E_CORRUPT_DATA);
        RETURN_CASE(MAPI_E_UNCONFIGURED);
        RETURN_CASE(MAPI_E_FAILONEPROVIDER);
        RETURN_CASE(MAPI_E_UNKNOWN_CPID);
        RETURN_CASE(MAPI_E_UNKNOWN_LCID);
        RETURN_CASE(MAPI_E_PASSWORD_CHANGE_REQUIRED);
        RETURN_CASE(MAPI_E_PASSWORD_EXPIRED);
        RETURN_CASE(MAPI_E_INVALID_WORKSTATION_ACCOUNT);
        RETURN_CASE(MAPI_E_INVALID_ACCESS_TIME);
        RETURN_CASE(MAPI_E_ACCOUNT_DISABLED);
        RETURN_CASE(MAPI_E_END_OF_SESSION);
        RETURN_CASE(MAPI_E_UNKNOWN_ENTRYID);
        RETURN_CASE(MAPI_E_MISSING_REQUIRED_COLUMN);
        RETURN_CASE(MAPI_W_NO_SERVICE);
        RETURN_CASE(MAPI_E_BAD_VALUE);
        RETURN_CASE(MAPI_E_INVALID_TYPE);
        RETURN_CASE(MAPI_E_TYPE_NO_SUPPORT);
        RETURN_CASE(MAPI_E_UNEXPECTED_TYPE);
        RETURN_CASE(MAPI_E_TOO_BIG);
        RETURN_CASE(MAPI_E_DECLINE_COPY);
        RETURN_CASE(MAPI_E_UNEXPECTED_ID);
        RETURN_CASE(MAPI_W_ERRORS_RETURNED);
        RETURN_CASE(MAPI_E_UNABLE_TO_COMPLETE);
        RETURN_CASE(MAPI_E_TIMEOUT);
        RETURN_CASE(MAPI_E_TABLE_EMPTY);
        RETURN_CASE(MAPI_E_TABLE_TOO_BIG);
        RETURN_CASE(MAPI_E_INVALID_BOOKMARK);
        RETURN_CASE(MAPI_W_POSITION_CHANGED);
        RETURN_CASE(MAPI_W_APPROX_COUNT);
        RETURN_CASE(MAPI_E_WAIT);
        RETURN_CASE(MAPI_E_CANCEL);
        RETURN_CASE(MAPI_E_NOT_ME);
        RETURN_CASE(MAPI_W_CANCEL_MESSAGE);
        RETURN_CASE(MAPI_E_CORRUPT_STORE);
        RETURN_CASE(MAPI_E_NOT_IN_QUEUE);
        RETURN_CASE(MAPI_E_NO_SUPPRESS);
        RETURN_CASE(MAPI_E_COLLISION);
        RETURN_CASE(MAPI_E_NOT_INITIALIZED);
        RETURN_CASE(MAPI_E_NON_STANDARD);
        RETURN_CASE(MAPI_E_NO_RECIPIENTS);
        RETURN_CASE(MAPI_E_SUBMITTED);
        RETURN_CASE(MAPI_E_HAS_FOLDERS);
        RETURN_CASE(MAPI_E_HAS_MESSAGES);
        RETURN_CASE(MAPI_E_FOLDER_CYCLE);
        RETURN_CASE(MAPI_W_PARTIAL_COMPLETION);
        RETURN_CASE(MAPI_E_AMBIGUOUS_RECIP);
        default: return "Unknown";
    }
}

static QString objname( int obj )
{
    switch ( obj ) {
        RETURN_CASE(MAPI_ABCONT);
        RETURN_CASE(MAPI_ADDRBOOK);
        RETURN_CASE(MAPI_ATTACH);
        RETURN_CASE(MAPI_DISTLIST);
        RETURN_CASE(MAPI_FOLDER);
        RETURN_CASE(MAPI_FORMINFO);
        RETURN_CASE(MAPI_MAILUSER);
        RETURN_CASE(MAPI_MESSAGE);
        RETURN_CASE(MAPI_PROFSECT);
        RETURN_CASE(MAPI_SESSION);
        RETURN_CASE(MAPI_STATUS);
        RETURN_CASE(MAPI_STORE);
        default: return "Unknown";
    }
}

static QString propname( int prop )
{
    switch ( prop ) {
        RETURN_CASE(PT_UNSPECIFIED);
        RETURN_CASE(PT_NULL);
        RETURN_CASE(PT_I2);
        RETURN_CASE(PT_LONG);
        RETURN_CASE(PT_R4);
        RETURN_CASE(PT_DOUBLE);
        RETURN_CASE(PT_CURRENCY);
        RETURN_CASE(PT_APPTIME);
        RETURN_CASE(PT_ERROR);
        RETURN_CASE(PT_BOOLEAN);
        RETURN_CASE(PT_OBJECT);
        RETURN_CASE(PT_I8);
        RETURN_CASE(PT_STRING8);
        RETURN_CASE(PT_UNICODE);
        RETURN_CASE(PT_SYSTIME);
        RETURN_CASE(PT_CLSID);
        RETURN_CASE(PT_BINARY);
        default: return "Unknown";
    }
}

#define RETURN_PROP_CASE(pt) case PROP_ID(pt): return(QString(#pt))
static QString propid( int prop )
{
    switch ( prop ) {
        //Begin <MAPItags.h>
        RETURN_PROP_CASE(PR_ACKNOWLEDGEMENT_MODE);
        RETURN_PROP_CASE(PR_ALTERNATE_RECIPIENT_ALLOWED);
        RETURN_PROP_CASE(PR_AUTHORIZING_USERS);
        RETURN_PROP_CASE(PR_AUTO_FORWARD_COMMENT);
        RETURN_PROP_CASE(PR_AUTO_FORWARDED);
        RETURN_PROP_CASE(PR_CONTENT_CONFIDENTIALITY_ALGORITHM_ID);
        RETURN_PROP_CASE(PR_CONTENT_CORRELATOR);
        RETURN_PROP_CASE(PR_CONTENT_IDENTIFIER);
        RETURN_PROP_CASE(PR_CONTENT_LENGTH);
        RETURN_PROP_CASE(PR_CONTENT_RETURN_REQUESTED);
        RETURN_PROP_CASE(PR_CONVERSATION_KEY);
        RETURN_PROP_CASE(PR_CONVERSION_EITS);
        RETURN_PROP_CASE(PR_CONVERSION_WITH_LOSS_PROHIBITED);
        RETURN_PROP_CASE(PR_CONVERTED_EITS);
        RETURN_PROP_CASE(PR_DEFERRED_DELIVERY_TIME);
        RETURN_PROP_CASE(PR_DELIVER_TIME);
        RETURN_PROP_CASE(PR_DISCARD_REASON);
        RETURN_PROP_CASE(PR_DISCLOSURE_OF_RECIPIENTS);
        RETURN_PROP_CASE(PR_DL_EXPANSION_HISTORY);
        RETURN_PROP_CASE(PR_DL_EXPANSION_PROHIBITED);
        RETURN_PROP_CASE(PR_EXPIRY_TIME);
        RETURN_PROP_CASE(PR_IMPLICIT_CONVERSION_PROHIBITED);
        RETURN_PROP_CASE(PR_IMPORTANCE);
        RETURN_PROP_CASE(PR_IPM_ID);
        RETURN_PROP_CASE(PR_LATEST_DELIVERY_TIME);
        RETURN_PROP_CASE(PR_MESSAGE_CLASS);
        RETURN_PROP_CASE(PR_MESSAGE_DELIVERY_ID);
        RETURN_PROP_CASE(PR_MESSAGE_SECURITY_LABEL);
        RETURN_PROP_CASE(PR_OBSOLETED_IPMS);
        RETURN_PROP_CASE(PR_ORIGINALLY_INTENDED_RECIPIENT_NAME);
        RETURN_PROP_CASE(PR_ORIGINAL_EITS);
        RETURN_PROP_CASE(PR_ORIGINATOR_CERTIFICATE);
        RETURN_PROP_CASE(PR_ORIGINATOR_DELIVERY_REPORT_REQUESTED);
        RETURN_PROP_CASE(PR_ORIGINATOR_RETURN_ADDRESS);
        RETURN_PROP_CASE(PR_PARENT_KEY);
        RETURN_PROP_CASE(PR_PRIORITY);
        RETURN_PROP_CASE(PR_ORIGIN_CHECK);
        RETURN_PROP_CASE(PR_PROOF_OF_SUBMISSION_REQUESTED);
        RETURN_PROP_CASE(PR_READ_RECEIPT_REQUESTED);
        RETURN_PROP_CASE(PR_RECEIPT_TIME);
        RETURN_PROP_CASE(PR_RECIPIENT_REASSIGNMENT_PROHIBITED);
        RETURN_PROP_CASE(PR_REDIRECTION_HISTORY);
        RETURN_PROP_CASE(PR_RELATED_IPMS);
        RETURN_PROP_CASE(PR_ORIGINAL_SENSITIVITY);
        RETURN_PROP_CASE(PR_LANGUAGES);
        RETURN_PROP_CASE(PR_REPLY_TIME);
        RETURN_PROP_CASE(PR_REPORT_TAG);
        RETURN_PROP_CASE(PR_REPORT_TIME);
        RETURN_PROP_CASE(PR_RETURNED_IPM);
        RETURN_PROP_CASE(PR_SECURITY);
        RETURN_PROP_CASE(PR_INCOMPLETE_COPY);
        RETURN_PROP_CASE(PR_SENSITIVITY);
        RETURN_PROP_CASE(PR_SUBJECT);
        RETURN_PROP_CASE(PR_SUBJECT_IPM);
        RETURN_PROP_CASE(PR_CLIENT_SUBMIT_TIME);
        RETURN_PROP_CASE(PR_REPORT_NAME);
        RETURN_PROP_CASE(PR_SENT_REPRESENTING_SEARCH_KEY);
        RETURN_PROP_CASE(PR_X400_CONTENT_TYPE);
        RETURN_PROP_CASE(PR_SUBJECT_PREFIX);
        RETURN_PROP_CASE(PR_NON_RECEIPT_REASON);
        RETURN_PROP_CASE(PR_RECEIVED_BY_ENTRYID);
        RETURN_PROP_CASE(PR_RECEIVED_BY_NAME);
        RETURN_PROP_CASE(PR_SENT_REPRESENTING_ENTRYID);
        RETURN_PROP_CASE(PR_SENT_REPRESENTING_NAME);
        RETURN_PROP_CASE(PR_RCVD_REPRESENTING_ENTRYID);
        RETURN_PROP_CASE(PR_RCVD_REPRESENTING_NAME);
        RETURN_PROP_CASE(PR_REPORT_ENTRYID);
        RETURN_PROP_CASE(PR_READ_RECEIPT_ENTRYID);
        RETURN_PROP_CASE(PR_MESSAGE_SUBMISSION_ID);
        RETURN_PROP_CASE(PR_PROVIDER_SUBMIT_TIME);
        RETURN_PROP_CASE(PR_ORIGINAL_SUBJECT);
        RETURN_PROP_CASE(PR_DISC_VAL);
        RETURN_PROP_CASE(PR_ORIG_MESSAGE_CLASS);
        RETURN_PROP_CASE(PR_ORIGINAL_AUTHOR_ENTRYID);
        RETURN_PROP_CASE(PR_ORIGINAL_AUTHOR_NAME);
        RETURN_PROP_CASE(PR_ORIGINAL_SUBMIT_TIME);
        RETURN_PROP_CASE(PR_REPLY_RECIPIENT_ENTRIES);
        RETURN_PROP_CASE(PR_REPLY_RECIPIENT_NAMES);
        RETURN_PROP_CASE(PR_RECEIVED_BY_SEARCH_KEY);
        RETURN_PROP_CASE(PR_RCVD_REPRESENTING_SEARCH_KEY);
        RETURN_PROP_CASE(PR_READ_RECEIPT_SEARCH_KEY);
        RETURN_PROP_CASE(PR_REPORT_SEARCH_KEY);
        RETURN_PROP_CASE(PR_ORIGINAL_DELIVERY_TIME);
        RETURN_PROP_CASE(PR_ORIGINAL_AUTHOR_SEARCH_KEY);
        RETURN_PROP_CASE(PR_MESSAGE_TO_ME);
        RETURN_PROP_CASE(PR_MESSAGE_CC_ME);
        RETURN_PROP_CASE(PR_MESSAGE_RECIP_ME);
        RETURN_PROP_CASE(PR_ORIGINAL_SENDER_NAME);
        RETURN_PROP_CASE(PR_ORIGINAL_SENDER_ENTRYID);
        RETURN_PROP_CASE(PR_ORIGINAL_SENDER_SEARCH_KEY);
        RETURN_PROP_CASE(PR_ORIGINAL_SENT_REPRESENTING_NAME);
        RETURN_PROP_CASE(PR_ORIGINAL_SENT_REPRESENTING_ENTRYID);
        RETURN_PROP_CASE(PR_ORIGINAL_SENT_REPRESENTING_SEARCH_KEY);
        RETURN_PROP_CASE(PR_START_DATE);
        RETURN_PROP_CASE(PR_END_DATE);
        RETURN_PROP_CASE(PR_OWNER_APPT_ID);
        RETURN_PROP_CASE(PR_RESPONSE_REQUESTED);
        RETURN_PROP_CASE(PR_SENT_REPRESENTING_ADDRTYPE);
        RETURN_PROP_CASE(PR_SENT_REPRESENTING_EMAIL_ADDRESS);
        RETURN_PROP_CASE(PR_ORIGINAL_SENDER_ADDRTYPE);
        RETURN_PROP_CASE(PR_ORIGINAL_SENDER_EMAIL_ADDRESS);
        RETURN_PROP_CASE(PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE);
        RETURN_PROP_CASE(PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS);
        RETURN_PROP_CASE(PR_CONVERSATION_TOPIC);
        RETURN_PROP_CASE(PR_CONVERSATION_INDEX);
        RETURN_PROP_CASE(PR_ORIGINAL_DISPLAY_BCC);
        RETURN_PROP_CASE(PR_ORIGINAL_DISPLAY_CC);
        RETURN_PROP_CASE(PR_ORIGINAL_DISPLAY_TO);
        RETURN_PROP_CASE(PR_RECEIVED_BY_ADDRTYPE);
        RETURN_PROP_CASE(PR_RECEIVED_BY_EMAIL_ADDRESS);
        RETURN_PROP_CASE(PR_RCVD_REPRESENTING_ADDRTYPE);
        RETURN_PROP_CASE(PR_RCVD_REPRESENTING_EMAIL_ADDRESS);
        RETURN_PROP_CASE(PR_ORIGINAL_AUTHOR_ADDRTYPE);
        RETURN_PROP_CASE(PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS);
        RETURN_PROP_CASE(PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE);
        RETURN_PROP_CASE(PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS);
        RETURN_PROP_CASE(PR_TRANSPORT_MESSAGE_HEADERS);
        RETURN_PROP_CASE(PR_DELEGATION);
        RETURN_PROP_CASE(PR_TNEF_CORRELATION_KEY);
        RETURN_PROP_CASE(PR_BODY);
        RETURN_PROP_CASE(PR_REPORT_TEXT);
        RETURN_PROP_CASE(PR_ORIGINATOR_AND_DL_EXPANSION_HISTORY);
        RETURN_PROP_CASE(PR_REPORTING_DL_NAME);
        RETURN_PROP_CASE(PR_REPORTING_MTA_CERTIFICATE);
        RETURN_PROP_CASE(PR_RTF_SYNC_BODY_CRC);
        RETURN_PROP_CASE(PR_RTF_SYNC_BODY_COUNT);
        RETURN_PROP_CASE(PR_RTF_SYNC_BODY_TAG);
        RETURN_PROP_CASE(PR_RTF_COMPRESSED);
        RETURN_PROP_CASE(PR_RTF_SYNC_PREFIX_COUNT);
        RETURN_PROP_CASE(PR_RTF_SYNC_TRAILING_COUNT);
        RETURN_PROP_CASE(PR_ORIGINALLY_INTENDED_RECIP_ENTRYID);
        RETURN_PROP_CASE(PR_CONTENT_INTEGRITY_CHECK);
        RETURN_PROP_CASE(PR_EXPLICIT_CONVERSION);
        RETURN_PROP_CASE(PR_IPM_RETURN_REQUESTED);
        RETURN_PROP_CASE(PR_MESSAGE_TOKEN);
        RETURN_PROP_CASE(PR_NDR_REASON_CODE);
        RETURN_PROP_CASE(PR_NDR_DIAG_CODE);
        RETURN_PROP_CASE(PR_NON_RECEIPT_NOTIFICATION_REQUESTED);
        RETURN_PROP_CASE(PR_DELIVERY_POINT);
        RETURN_PROP_CASE(PR_ORIGINATOR_NON_DELIVERY_REPORT_REQUESTED);
        RETURN_PROP_CASE(PR_ORIGINATOR_REQUESTED_ALTERNATE_RECIPIENT);
        RETURN_PROP_CASE(PR_PHYSICAL_DELIVERY_BUREAU_FAX_DELIVERY);
        RETURN_PROP_CASE(PR_PHYSICAL_DELIVERY_MODE);
        RETURN_PROP_CASE(PR_PHYSICAL_DELIVERY_REPORT_REQUEST);
        RETURN_PROP_CASE(PR_PHYSICAL_FORWARDING_ADDRESS);
        RETURN_PROP_CASE(PR_PHYSICAL_FORWARDING_ADDRESS_REQUESTED);
        RETURN_PROP_CASE(PR_PHYSICAL_FORWARDING_PROHIBITED);
        RETURN_PROP_CASE(PR_PHYSICAL_RENDITION_ATTRIBUTES);
        RETURN_PROP_CASE(PR_PROOF_OF_DELIVERY);
        RETURN_PROP_CASE(PR_PROOF_OF_DELIVERY_REQUESTED);
        RETURN_PROP_CASE(PR_RECIPIENT_CERTIFICATE);
        RETURN_PROP_CASE(PR_RECIPIENT_NUMBER_FOR_ADVICE);
        RETURN_PROP_CASE(PR_RECIPIENT_TYPE);
        RETURN_PROP_CASE(PR_REGISTERED_MAIL_TYPE);
        RETURN_PROP_CASE(PR_REPLY_REQUESTED);
        RETURN_PROP_CASE(PR_REQUESTED_DELIVERY_METHOD);
        RETURN_PROP_CASE(PR_SENDER_ENTRYID);
        RETURN_PROP_CASE(PR_SENDER_NAME);
        RETURN_PROP_CASE(PR_SUPPLEMENTARY_INFO);
        RETURN_PROP_CASE(PR_TYPE_OF_MTS_USER);
        RETURN_PROP_CASE(PR_SENDER_SEARCH_KEY);
        RETURN_PROP_CASE(PR_SENDER_ADDRTYPE);
        RETURN_PROP_CASE(PR_SENDER_EMAIL_ADDRESS);
        RETURN_PROP_CASE(PR_CURRENT_VERSION);
        RETURN_PROP_CASE(PR_DELETE_AFTER_SUBMIT);
        RETURN_PROP_CASE(PR_DISPLAY_BCC);
        RETURN_PROP_CASE(PR_DISPLAY_CC);
        RETURN_PROP_CASE(PR_DISPLAY_TO);
        RETURN_PROP_CASE(PR_PARENT_DISPLAY);
        RETURN_PROP_CASE(PR_MESSAGE_DELIVERY_TIME);
        RETURN_PROP_CASE(PR_MESSAGE_FLAGS);
        RETURN_PROP_CASE(PR_MESSAGE_SIZE);
        RETURN_PROP_CASE(PR_PARENT_ENTRYID);
        RETURN_PROP_CASE(PR_SENTMAIL_ENTRYID);
        RETURN_PROP_CASE(PR_CORRELATE);
        RETURN_PROP_CASE(PR_CORRELATE_MTSID);
        RETURN_PROP_CASE(PR_DISCRETE_VALUES);
        RETURN_PROP_CASE(PR_RESPONSIBILITY);
        RETURN_PROP_CASE(PR_SPOOLER_STATUS);
        RETURN_PROP_CASE(PR_TRANSPORT_STATUS);
        RETURN_PROP_CASE(PR_MESSAGE_RECIPIENTS);
        RETURN_PROP_CASE(PR_MESSAGE_ATTACHMENTS);
        RETURN_PROP_CASE(PR_SUBMIT_FLAGS);
        RETURN_PROP_CASE(PR_RECIPIENT_STATUS);
        RETURN_PROP_CASE(PR_TRANSPORT_KEY);
        RETURN_PROP_CASE(PR_MSG_STATUS);
        RETURN_PROP_CASE(PR_MESSAGE_DOWNLOAD_TIME);
        RETURN_PROP_CASE(PR_CREATION_VERSION);
        RETURN_PROP_CASE(PR_MODIFY_VERSION);
        RETURN_PROP_CASE(PR_HASATTACH);
        RETURN_PROP_CASE(PR_BODY_CRC);
        RETURN_PROP_CASE(PR_NORMALIZED_SUBJECT);
        RETURN_PROP_CASE(PR_RTF_IN_SYNC);
        RETURN_PROP_CASE(PR_ATTACH_SIZE);
        RETURN_PROP_CASE(PR_ATTACH_NUM);
        RETURN_PROP_CASE(PR_PREPROCESS);
        RETURN_PROP_CASE(PR_ORIGINATING_MTA_CERTIFICATE);
        RETURN_PROP_CASE(PR_PROOF_OF_SUBMISSION);
        RETURN_PROP_CASE(PR_ENTRYID);
        RETURN_PROP_CASE(PR_OBJECT_TYPE);
        RETURN_PROP_CASE(PR_ICON);
        RETURN_PROP_CASE(PR_MINI_ICON);
        RETURN_PROP_CASE(PR_STORE_ENTRYID);
        RETURN_PROP_CASE(PR_STORE_RECORD_KEY);
        RETURN_PROP_CASE(PR_RECORD_KEY);
        RETURN_PROP_CASE(PR_MAPPING_SIGNATURE);
        RETURN_PROP_CASE(PR_ACCESS_LEVEL);
        RETURN_PROP_CASE(PR_INSTANCE_KEY);
        RETURN_PROP_CASE(PR_ROW_TYPE);
        RETURN_PROP_CASE(PR_ACCESS);
        RETURN_PROP_CASE(PR_ROWID);
        RETURN_PROP_CASE(PR_DISPLAY_NAME);
        RETURN_PROP_CASE(PR_ADDRTYPE);
        RETURN_PROP_CASE(PR_EMAIL_ADDRESS);
        RETURN_PROP_CASE(PR_COMMENT);
        RETURN_PROP_CASE(PR_DEPTH);
        RETURN_PROP_CASE(PR_PROVIDER_DISPLAY);
        RETURN_PROP_CASE(PR_CREATION_TIME);
        RETURN_PROP_CASE(PR_LAST_MODIFICATION_TIME);
        RETURN_PROP_CASE(PR_RESOURCE_FLAGS);
        RETURN_PROP_CASE(PR_PROVIDER_DLL_NAME);
        RETURN_PROP_CASE(PR_SEARCH_KEY);
        RETURN_PROP_CASE(PR_PROVIDER_UID);
        RETURN_PROP_CASE(PR_PROVIDER_ORDINAL);
        RETURN_PROP_CASE(PR_FORM_VERSION);
        RETURN_PROP_CASE(PR_FORM_CLSID);
        RETURN_PROP_CASE(PR_FORM_CONTACT_NAME);
        RETURN_PROP_CASE(PR_FORM_CATEGORY);
        RETURN_PROP_CASE(PR_FORM_CATEGORY_SUB);
        RETURN_PROP_CASE(PR_FORM_HOST_MAP);
        RETURN_PROP_CASE(PR_FORM_HIDDEN);
        RETURN_PROP_CASE(PR_FORM_DESIGNER_NAME);
        RETURN_PROP_CASE(PR_FORM_DESIGNER_GUID);
        RETURN_PROP_CASE(PR_FORM_MESSAGE_BEHAVIOR);
        RETURN_PROP_CASE(PR_DEFAULT_STORE);
        RETURN_PROP_CASE(PR_STORE_SUPPORT_MASK);
        RETURN_PROP_CASE(PR_STORE_STATE);
        RETURN_PROP_CASE(PR_IPM_SUBTREE_SEARCH_KEY);
        RETURN_PROP_CASE(PR_IPM_OUTBOX_SEARCH_KEY);
        RETURN_PROP_CASE(PR_IPM_WASTEBASKET_SEARCH_KEY);
        RETURN_PROP_CASE(PR_IPM_SENTMAIL_SEARCH_KEY);
        RETURN_PROP_CASE(PR_MDB_PROVIDER);
        RETURN_PROP_CASE(PR_RECEIVE_FOLDER_SETTINGS);
        RETURN_PROP_CASE(PR_VALID_FOLDER_MASK);
        RETURN_PROP_CASE(PR_IPM_SUBTREE_ENTRYID);
        RETURN_PROP_CASE(PR_IPM_OUTBOX_ENTRYID);
        RETURN_PROP_CASE(PR_IPM_WASTEBASKET_ENTRYID);
        RETURN_PROP_CASE(PR_IPM_SENTMAIL_ENTRYID);
        RETURN_PROP_CASE(PR_VIEWS_ENTRYID);
        RETURN_PROP_CASE(PR_COMMON_VIEWS_ENTRYID);
        RETURN_PROP_CASE(PR_FINDER_ENTRYID);
        RETURN_PROP_CASE(PR_CONTAINER_FLAGS);
        RETURN_PROP_CASE(PR_FOLDER_TYPE);
        RETURN_PROP_CASE(PR_CONTENT_COUNT);
        RETURN_PROP_CASE(PR_CONTENT_UNREAD);
        RETURN_PROP_CASE(PR_CREATE_TEMPLATES);
        RETURN_PROP_CASE(PR_DETAILS_TABLE);
        RETURN_PROP_CASE(PR_SEARCH);
        RETURN_PROP_CASE(PR_SELECTABLE);
        RETURN_PROP_CASE(PR_SUBFOLDERS);
        RETURN_PROP_CASE(PR_STATUS);
        RETURN_PROP_CASE(PR_ANR);
        RETURN_PROP_CASE(PR_CONTENTS_SORT_ORDER);
        RETURN_PROP_CASE(PR_CONTAINER_HIERARCHY);
        RETURN_PROP_CASE(PR_CONTAINER_CONTENTS);
        RETURN_PROP_CASE(PR_FOLDER_ASSOCIATED_CONTENTS);
        RETURN_PROP_CASE(PR_DEF_CREATE_DL);
        RETURN_PROP_CASE(PR_DEF_CREATE_MAILUSER);
        RETURN_PROP_CASE(PR_CONTAINER_CLASS);
        RETURN_PROP_CASE(PR_CONTAINER_MODIFY_VERSION);
        RETURN_PROP_CASE(PR_AB_PROVIDER_ID);
        RETURN_PROP_CASE(PR_DEFAULT_VIEW_ENTRYID);
        RETURN_PROP_CASE(PR_ASSOC_CONTENT_COUNT);
        RETURN_PROP_CASE(PR_ATTACHMENT_X400_PARAMETERS);
        RETURN_PROP_CASE(PR_ATTACH_DATA_OBJ);
        RETURN_PROP_CASE(PR_ATTACH_ENCODING);
        RETURN_PROP_CASE(PR_ATTACH_EXTENSION);
        RETURN_PROP_CASE(PR_ATTACH_FILENAME);
        RETURN_PROP_CASE(PR_ATTACH_METHOD);
        RETURN_PROP_CASE(PR_ATTACH_LONG_FILENAME);
        RETURN_PROP_CASE(PR_ATTACH_PATHNAME);
        RETURN_PROP_CASE(PR_ATTACH_RENDERING);
        RETURN_PROP_CASE(PR_ATTACH_TAG);
        RETURN_PROP_CASE(PR_RENDERING_POSITION);
        RETURN_PROP_CASE(PR_ATTACH_TRANSPORT_NAME);
        RETURN_PROP_CASE(PR_ATTACH_LONG_PATHNAME);
        RETURN_PROP_CASE(PR_ATTACH_MIME_TAG);
        RETURN_PROP_CASE(PR_ATTACH_ADDITIONAL_INFO);
        RETURN_PROP_CASE(PR_DISPLAY_TYPE);
        RETURN_PROP_CASE(PR_TEMPLATEID);
        RETURN_PROP_CASE(PR_PRIMARY_CAPABILITY);
        RETURN_PROP_CASE(PR_7BIT_DISPLAY_NAME);
        RETURN_PROP_CASE(PR_ACCOUNT);
        RETURN_PROP_CASE(PR_ALTERNATE_RECIPIENT);
        RETURN_PROP_CASE(PR_CALLBACK_TELEPHONE_NUMBER);
        RETURN_PROP_CASE(PR_CONVERSION_PROHIBITED);
        RETURN_PROP_CASE(PR_DISCLOSE_RECIPIENTS);
        RETURN_PROP_CASE(PR_GENERATION);
        RETURN_PROP_CASE(PR_GIVEN_NAME);
        RETURN_PROP_CASE(PR_GOVERNMENT_ID_NUMBER);
        RETURN_PROP_CASE(PR_BUSINESS_TELEPHONE_NUMBER);
        RETURN_PROP_CASE(PR_HOME_TELEPHONE_NUMBER);
        RETURN_PROP_CASE(PR_INITIALS);
        RETURN_PROP_CASE(PR_KEYWORD);
        RETURN_PROP_CASE(PR_LANGUAGE);
        RETURN_PROP_CASE(PR_LOCATION);
        RETURN_PROP_CASE(PR_MAIL_PERMISSION);
        RETURN_PROP_CASE(PR_MHS_COMMON_NAME);
        RETURN_PROP_CASE(PR_ORGANIZATIONAL_ID_NUMBER);
        RETURN_PROP_CASE(PR_SURNAME);
        RETURN_PROP_CASE(PR_ORIGINAL_ENTRYID);
        RETURN_PROP_CASE(PR_ORIGINAL_DISPLAY_NAME);
        RETURN_PROP_CASE(PR_ORIGINAL_SEARCH_KEY);
        RETURN_PROP_CASE(PR_POSTAL_ADDRESS);
        RETURN_PROP_CASE(PR_COMPANY_NAME);
        RETURN_PROP_CASE(PR_TITLE);
        RETURN_PROP_CASE(PR_DEPARTMENT_NAME);
        RETURN_PROP_CASE(PR_OFFICE_LOCATION);
        RETURN_PROP_CASE(PR_PRIMARY_TELEPHONE_NUMBER);
        RETURN_PROP_CASE(PR_BUSINESS2_TELEPHONE_NUMBER);
        RETURN_PROP_CASE(PR_MOBILE_TELEPHONE_NUMBER);
        RETURN_PROP_CASE(PR_RADIO_TELEPHONE_NUMBER);
        RETURN_PROP_CASE(PR_CAR_TELEPHONE_NUMBER);
        RETURN_PROP_CASE(PR_OTHER_TELEPHONE_NUMBER);
        RETURN_PROP_CASE(PR_TRANSMITABLE_DISPLAY_NAME);
        RETURN_PROP_CASE(PR_PAGER_TELEPHONE_NUMBER);
        RETURN_PROP_CASE(PR_USER_CERTIFICATE);
        RETURN_PROP_CASE(PR_PRIMARY_FAX_NUMBER);
        RETURN_PROP_CASE(PR_BUSINESS_FAX_NUMBER);
        RETURN_PROP_CASE(PR_HOME_FAX_NUMBER);
        RETURN_PROP_CASE(PR_COUNTRY);
        RETURN_PROP_CASE(PR_LOCALITY);
        RETURN_PROP_CASE(PR_STATE_OR_PROVINCE);
        RETURN_PROP_CASE(PR_STREET_ADDRESS);
        RETURN_PROP_CASE(PR_POSTAL_CODE);
        RETURN_PROP_CASE(PR_POST_OFFICE_BOX);
        RETURN_PROP_CASE(PR_TELEX_NUMBER);
        RETURN_PROP_CASE(PR_ISDN_NUMBER);
        RETURN_PROP_CASE(PR_ASSISTANT_TELEPHONE_NUMBER);
        RETURN_PROP_CASE(PR_HOME2_TELEPHONE_NUMBER);
        RETURN_PROP_CASE(PR_ASSISTANT);
        RETURN_PROP_CASE(PR_SEND_RICH_INFO);
        RETURN_PROP_CASE(PR_WEDDING_ANNIVERSARY);
        RETURN_PROP_CASE(PR_BIRTHDAY);
        RETURN_PROP_CASE(PR_HOBBIES);
        RETURN_PROP_CASE(PR_MIDDLE_NAME);
        RETURN_PROP_CASE(PR_DISPLAY_NAME_PREFIX);
        RETURN_PROP_CASE(PR_PROFESSION);
        RETURN_PROP_CASE(PR_PREFERRED_BY_NAME);
        RETURN_PROP_CASE(PR_SPOUSE_NAME);
        RETURN_PROP_CASE(PR_COMPUTER_NETWORK_NAME);
        RETURN_PROP_CASE(PR_CUSTOMER_ID);
        RETURN_PROP_CASE(PR_TTYTDD_PHONE_NUMBER);
        RETURN_PROP_CASE(PR_FTP_SITE);
        RETURN_PROP_CASE(PR_GENDER);
        RETURN_PROP_CASE(PR_MANAGER_NAME);
        RETURN_PROP_CASE(PR_NICKNAME);
        RETURN_PROP_CASE(PR_PERSONAL_HOME_PAGE);
        RETURN_PROP_CASE(PR_BUSINESS_HOME_PAGE);
        RETURN_PROP_CASE(PR_CONTACT_VERSION);
        RETURN_PROP_CASE(PR_CONTACT_ENTRYIDS);
        RETURN_PROP_CASE(PR_CONTACT_ADDRTYPES);
        RETURN_PROP_CASE(PR_CONTACT_DEFAULT_ADDRESS_INDEX);
        RETURN_PROP_CASE(PR_CONTACT_EMAIL_ADDRESSES);
        RETURN_PROP_CASE(PR_COMPANY_MAIN_PHONE_NUMBER);
        RETURN_PROP_CASE(PR_CHILDRENS_NAMES);
        RETURN_PROP_CASE(PR_HOME_ADDRESS_CITY);
        RETURN_PROP_CASE(PR_HOME_ADDRESS_COUNTRY);
        RETURN_PROP_CASE(PR_HOME_ADDRESS_POSTAL_CODE);
        RETURN_PROP_CASE(PR_HOME_ADDRESS_STATE_OR_PROVINCE);
        RETURN_PROP_CASE(PR_HOME_ADDRESS_STREET);
        RETURN_PROP_CASE(PR_HOME_ADDRESS_POST_OFFICE_BOX);
        RETURN_PROP_CASE(PR_OTHER_ADDRESS_CITY);
        RETURN_PROP_CASE(PR_OTHER_ADDRESS_COUNTRY);
        RETURN_PROP_CASE(PR_OTHER_ADDRESS_POSTAL_CODE);
        RETURN_PROP_CASE(PR_OTHER_ADDRESS_STATE_OR_PROVINCE);
        RETURN_PROP_CASE(PR_OTHER_ADDRESS_STREET);
        RETURN_PROP_CASE(PR_OTHER_ADDRESS_POST_OFFICE_BOX);
        RETURN_PROP_CASE(PR_STORE_PROVIDERS);
        RETURN_PROP_CASE(PR_AB_PROVIDERS);
        RETURN_PROP_CASE(PR_TRANSPORT_PROVIDERS);
        RETURN_PROP_CASE(PR_DEFAULT_PROFILE);
        RETURN_PROP_CASE(PR_AB_SEARCH_PATH);
        RETURN_PROP_CASE(PR_AB_DEFAULT_DIR);
        RETURN_PROP_CASE(PR_AB_DEFAULT_PAB);
        RETURN_PROP_CASE(PR_FILTERING_HOOKS);
        RETURN_PROP_CASE(PR_SERVICE_NAME);
        RETURN_PROP_CASE(PR_SERVICE_DLL_NAME);
        RETURN_PROP_CASE(PR_SERVICE_ENTRY_NAME);
        RETURN_PROP_CASE(PR_SERVICE_UID);
        RETURN_PROP_CASE(PR_SERVICE_EXTRA_UIDS);
        RETURN_PROP_CASE(PR_SERVICES);
        RETURN_PROP_CASE(PR_SERVICE_SUPPORT_FILES);
        RETURN_PROP_CASE(PR_SERVICE_DELETE_FILES);
        RETURN_PROP_CASE(PR_AB_SEARCH_PATH_UPDATE);
        RETURN_PROP_CASE(PR_PROFILE_NAME);
        RETURN_PROP_CASE(PR_IDENTITY_DISPLAY);
        RETURN_PROP_CASE(PR_IDENTITY_ENTRYID);
        RETURN_PROP_CASE(PR_RESOURCE_METHODS);
        RETURN_PROP_CASE(PR_RESOURCE_TYPE);
        RETURN_PROP_CASE(PR_STATUS_CODE);
        RETURN_PROP_CASE(PR_IDENTITY_SEARCH_KEY);
        RETURN_PROP_CASE(PR_OWN_STORE_ENTRYID);
        RETURN_PROP_CASE(PR_RESOURCE_PATH);
        RETURN_PROP_CASE(PR_STATUS_STRING);
        RETURN_PROP_CASE(PR_X400_DEFERRED_DELIVERY_CANCEL);
        RETURN_PROP_CASE(PR_HEADER_FOLDER_ENTRYID);
        RETURN_PROP_CASE(PR_REMOTE_PROGRESS);
        RETURN_PROP_CASE(PR_REMOTE_PROGRESS_TEXT);
        RETURN_PROP_CASE(PR_REMOTE_VALIDATE_OK);
        RETURN_PROP_CASE(PR_CONTROL_FLAGS);
        RETURN_PROP_CASE(PR_CONTROL_STRUCTURE);
        RETURN_PROP_CASE(PR_CONTROL_TYPE);
        RETURN_PROP_CASE(PR_DELTAX);
        RETURN_PROP_CASE(PR_DELTAY);
        RETURN_PROP_CASE(PR_XPOS);
        RETURN_PROP_CASE(PR_YPOS);
        RETURN_PROP_CASE(PR_CONTROL_ID);
        RETURN_PROP_CASE(PR_INITIAL_DETAILS_PANE);
        //End <MAPItags.h>

        /*
        //<edkmdb.h>
        RETURN_PROP_CASE(PR_PROFILE_VERSION);
        RETURN_PROP_CASE(PR_PROFILE_CONFIG_FLAGS);
        RETURN_PROP_CASE(PR_PROFILE_HOME_SERVER);
        RETURN_PROP_CASE(PR_PROFILE_HOME_SERVER_DN);
        RETURN_PROP_CASE(PR_PROFILE_HOME_SERVER_ADDRS);
        RETURN_PROP_CASE(PR_PROFILE_USER);
        RETURN_PROP_CASE(PR_PROFILE_CONNECT_FLAGS);
        RETURN_PROP_CASE(PR_PROFILE_TRANSPORT_FLAGS);
        RETURN_PROP_CASE(PR_PROFILE_UI_STATE);
        RETURN_PROP_CASE(PR_PROFILE_UNRESOLVED_NAME);
        RETURN_PROP_CASE(PR_PROFILE_UNRESOLVED_SERVER);
        RETURN_PROP_CASE(PR_PROFILE_BINDING_ORDER);
        RETURN_PROP_CASE(PR_PROFILE_MAX_RESTRICT);
        RETURN_PROP_CASE(PR_PROFILE_AB_FILES_PATH);
        RETURN_PROP_CASE(PR_PROFILE_OFFLINE_STORE_PATH);
        RETURN_PROP_CASE(PR_PROFILE_OFFLINE_INFO);
        RETURN_PROP_CASE(PR_PROFILE_ADDR_INFO);
        RETURN_PROP_CASE(PR_PROFILE_OPTIONS_DATA);
        RETURN_PROP_CASE(PR_PROFILE_SECURE_MAILBOX);
        RETURN_PROP_CASE(PR_DISABLE_WINSOCK);
        RETURN_PROP_CASE(PR_PROFILE_AUTH_PACKAGE);
        RETURN_PROP_CASE(PR_PROFILE_RECONNECT_INTERVAL);

        RETURN_PROP_CASE(PR_OST_ENCRYPTION);
        //RETURN_PROP_CASE(PR_PROFILE_OPEN_FLAGS);
        RETURN_PROP_CASE(PR_PROFILE_TYPE);
        RETURN_PROP_CASE(PR_PROFILE_MAILBOX);
        RETURN_PROP_CASE(PR_PROFILE_SERVER);
        RETURN_PROP_CASE(PR_PROFILE_SERVER_DN);
        RETURN_PROP_CASE(PR_PROFILE_FAVFLD_DISPLAY_NAME);
        RETURN_PROP_CASE(PR_PROFILE_FAVFLD_COMMENT);
        RETURN_PROP_CASE(PR_PROFILE_ALLPUB_DISPLAY_NAME);
        RETURN_PROP_CASE(PR_PROFILE_ALLPUB_COMMENT);
        RETURN_PROP_CASE(PR_PROFILE_MOAB);
        RETURN_PROP_CASE(PR_PROFILE_MOAB_GUID);
        RETURN_PROP_CASE(PR_PROFILE_MOAB_SEQ);
        RETURN_PROP_CASE(PR_GET_PROPS_EXCLUDE_PROP_ID_LIST);

        //RETURN_PROP_CASE(PR_USER_ENTRYID);
        //RETURN_PROP_CASE(PR_USER_NAME);
        RETURN_PROP_CASE(PR_MAILBOX_OWNER_ENTRYID);
        RETURN_PROP_CASE(PR_MAILBOX_OWNER_NAME);
        RETURN_PROP_CASE(PR_OOF_STATE);
        RETURN_PROP_CASE(PR_HIERARCHY_SERVER);
        RETURN_PROP_CASE(PR_SCHEDULE_FOLDER_ENTRYID);
        RETURN_PROP_CASE(PR_IPM_DAF_ENTRYID);
        RETURN_PROP_CASE(PR_NON_IPM_SUBTREE_ENTRYID);
        RETURN_PROP_CASE(PR_EFORMS_REGISTRY_ENTRYID);
        RETURN_PROP_CASE(PR_SPLUS_FREE_BUSY_ENTRYID);
        RETURN_PROP_CASE(PR_OFFLINE_ADDRBOOK_ENTRYID);
        RETURN_PROP_CASE(PR_EFORMS_FOR_LOCALE_ENTRYID);
        RETURN_PROP_CASE(PR_FREE_BUSY_FOR_LOCAL_SITE_ENTRYID);
        RETURN_PROP_CASE(PR_ADDRBOOK_FOR_LOCAL_SITE_ENTRYID);
        RETURN_PROP_CASE(PR_NEWSGROUP_ROOT_FOLDER_ENTRYID);
        RETURN_PROP_CASE(PR_OFFLINE_MESSAGE_ENTRYID);
        RETURN_PROP_CASE(PR_IPM_FAVORITES_ENTRYID);
        RETURN_PROP_CASE(PR_IPM_PUBLIC_FOLDERS_ENTRYID);
        RETURN_PROP_CASE(PR_FAVORITES_DEFAULT_NAME);
        RETURN_PROP_CASE(PR_SYS_CONFIG_FOLDER_ENTRYID);
        RETURN_PROP_CASE(PR_NNTP_ARTICLE_FOLDER_ENTRYID);
        RETURN_PROP_CASE(PR_EVENTS_ROOT_FOLDER_ENTRYID);

        RETURN_PROP_CASE(PR_GW_MTSIN_ENTRYID);
        RETURN_PROP_CASE(PR_GW_MTSOUT_ENTRYID);
        RETURN_PROP_CASE(PR_TRANSFER_ENABLED);
        RETURN_PROP_CASE(PR_TEST_LINE_SPEED);
        RETURN_PROP_CASE(PR_HIERARCHY_SYNCHRONIZER);
        RETURN_PROP_CASE(PR_CONTENTS_SYNCHRONIZER);
        RETURN_PROP_CASE(PR_COLLECTOR);
        RETURN_PROP_CASE(PR_FAST_TRANSFER);
        RETURN_PROP_CASE(PR_CHANGE_ADVISOR);
        RETURN_PROP_CASE(PR_CHANGE_NOTIFICATION_GUID);
        RETURN_PROP_CASE(PR_STORE_OFFLINE);
        //RETURN_PROP_CASE(PR_IN_TRANSIT);
        RETURN_PROP_CASE(PR_REPLICATION_STYLE);
        RETURN_PROP_CASE(PR_REPLICATION_SCHEDULE);
        RETURN_PROP_CASE(PR_REPLICATION_MESSAGE_PRIORITY);
        RETURN_PROP_CASE(PR_OVERALL_MSG_AGE_LIMIT);
        RETURN_PROP_CASE(PR_REPLICATION_ALWAYS_INTERVAL);
        RETURN_PROP_CASE(PR_REPLICATION_MSG_SIZE);
        RETURN_PROP_CASE(PR_SOURCE_KEY);
        RETURN_PROP_CASE(PR_PARENT_SOURCE_KEY);
        RETURN_PROP_CASE(PR_CHANGE_KEY);
        RETURN_PROP_CASE(PR_PREDECESSOR_CHANGE_LIST);
        RETURN_PROP_CASE(PR_FOLDER_CHILD_COUNT);
        RETURN_PROP_CASE(PR_RIGHTS);
        RETURN_PROP_CASE(PR_ACL_TABLE);
        RETURN_PROP_CASE(PR_RULES_TABLE);
        RETURN_PROP_CASE(PR_HAS_RULES);
        RETURN_PROP_CASE(PR_HAS_MODERATOR_RULES);
        RETURN_PROP_CASE(PR_ADDRESS_BOOK_ENTRYID);
        //RETURN_PROP_CASE(PR_ACL_DATA);
        //RETURN_PROP_CASE(PR_RULES_DATA);
        RETURN_PROP_CASE(PR_EXTENDED_ACL_DATA);

        RETURN_PROP_CASE(PR_FOLDER_DESIGN_FLAGS);
        RETURN_PROP_CASE(PR_DESIGN_IN_PROGRESS);
        RETURN_PROP_CASE(PR_SECURE_ORIGINATION);
        RETURN_PROP_CASE(PR_PUBLISH_IN_ADDRESS_BOOK);
        RETURN_PROP_CASE(PR_RESOLVE_METHOD);
        RETURN_PROP_CASE(PR_ADDRESS_BOOK_DISPLAY_NAME);
        RETURN_PROP_CASE(PR_EFORMS_LOCALE_ID);
        RETURN_PROP_CASE(PR_REPLICA_LIST);
        RETURN_PROP_CASE(PR_OVERALL_AGE_LIMIT);
        RETURN_PROP_CASE(PR_IS_NEWSGROUP_ANCHOR);
        RETURN_PROP_CASE(PR_IS_NEWSGROUP);
        RETURN_PROP_CASE(PR_NEWSGROUP_COMPONENT);
        RETURN_PROP_CASE(PR_INTERNET_NEWSGROUP_NAME);
        RETURN_PROP_CASE(PR_NEWSFEED_INFO);
        RETURN_PROP_CASE(PR_PREVENT_MSG_CREATE);
        RETURN_PROP_CASE(PR_IMAP_INTERNAL_DATE);
        RETURN_PROP_CASE(PR_INBOUND_NEWSFEED_DN);
        RETURN_PROP_CASE(PR_OUTBOUND_NEWSFEED_DN);
        RETURN_PROP_CASE(PR_INTERNET_CHARSET);

        RETURN_PROP_CASE(PR_PUBLIC_FOLDER_ENTRYID);
        RETURN_PROP_CASE(PR_HIERARCHY_CHANGE_NUM);
        RETURN_PROP_CASE(PR_HAS_NAMED_PROPERTIES);
        RETURN_PROP_CASE(PR_CREATOR_NAME);
        RETURN_PROP_CASE(PR_CREATOR_ENTRYID);
        RETURN_PROP_CASE(PR_LAST_MODIFIER_NAME);
        RETURN_PROP_CASE(PR_LAST_MODIFIER_ENTRYID);
        RETURN_PROP_CASE(PR_REPLY_RECIPIENT_SMTP_PROXIES);
        RETURN_PROP_CASE(PR_HAS_DAMS);
        RETURN_PROP_CASE(PR_RULE_TRIGGER_HISTORY);
        RETURN_PROP_CASE(PR_MOVE_TO_STORE_ENTRYID);
        RETURN_PROP_CASE(PR_MOVE_TO_FOLDER_ENTRYID);
        RETURN_PROP_CASE(PR_REPLICA_SERVER);
        RETURN_PROP_CASE(PR_REPLICA_VERSION);
        RETURN_PROP_CASE(PR_DEFERRED_SEND_NUMBER);
        RETURN_PROP_CASE(PR_DEFERRED_SEND_UNITS);
        RETURN_PROP_CASE(PR_EXPIRY_NUMBER);
        RETURN_PROP_CASE(PR_EXPIRY_UNITS);
        RETURN_PROP_CASE(PR_DEFERRED_SEND_TIME);
        RETURN_PROP_CASE(PR_GW_ADMIN_OPERATIONS);
        RETURN_PROP_CASE(PR_P1_CONTENT);
        RETURN_PROP_CASE(PR_P1_CONTENT_TYPE);
        RETURN_PROP_CASE(PR_CLIENT_ACTIONS);
        RETURN_PROP_CASE(PR_DAM_ORIGINAL_ENTRYID);
        RETURN_PROP_CASE(PR_DAM_BACK_PATCHED);
        RETURN_PROP_CASE(PR_RULE_ERROR);
        RETURN_PROP_CASE(PR_RULE_ACTION_TYPE);
        RETURN_PROP_CASE(PR_RULE_ACTION_NUMBER);
        RETURN_PROP_CASE(PR_RULE_FOLDER_ENTRYID);
        RETURN_PROP_CASE(PR_ACTIVE_USER_ENTRYID);
        RETURN_PROP_CASE(PR_CONFLICT_ENTRYID);
        RETURN_PROP_CASE(PR_MESSAGE_LOCALE_ID);
        RETURN_PROP_CASE(PR_MESSAGE_CODEPAGE);
        RETURN_PROP_CASE(PR_STORAGE_QUOTA_LIMIT);
        RETURN_PROP_CASE(PR_EXCESS_STORAGE_USED);
        RETURN_PROP_CASE(PR_SVR_GENERATING_QUOTA_MSG);
        RETURN_PROP_CASE(PR_DELEGATED_BY_RULE);
        RETURN_PROP_CASE(PR_X400_ENVELOPE_TYPE);
        RETURN_PROP_CASE(PR_AUTO_RESPONSE_SUPPRESS);
        RETURN_PROP_CASE(PR_INTERNET_CPID);

        RETURN_PROP_CASE(PR_IN_CONFLICT);
        RETURN_PROP_CASE(PR_DELETED_ON);
        RETURN_PROP_CASE(PR_DELETED_MSG_COUNT);
        RETURN_PROP_CASE(PR_DELETED_ASSOC_MSG_COUNT);
        RETURN_PROP_CASE(PR_DELETED_FOLDER_COUNT);
        RETURN_PROP_CASE(PR_OLDEST_DELETED_ON);
        RETURN_PROP_CASE(PR_DELETED_MESSAGE_SIZE_EXTENDED);
        RETURN_PROP_CASE(PR_DELETED_NORMAL_MESSAGE_SIZE_EXTENDED);
        RETURN_PROP_CASE(PR_DELETED_ASSOC_MESSAGE_SIZE_EXTENDED);
        RETURN_PROP_CASE(PR_RETENTION_AGE_LIMIT);
        RETURN_PROP_CASE(PR_LAST_FULL_BACKUP);
        RETURN_PROP_CASE(PR_SECURE_IN_SITE);

        RETURN_PROP_CASE(PR_LONGTERM_ENTRYID_FROM_TABLE);
        RETURN_PROP_CASE(PR_ORIGINATOR_NAME);
        RETURN_PROP_CASE(PR_ORIGINATOR_ADDR);
        RETURN_PROP_CASE(PR_ORIGINATOR_ADDRTYPE);
        RETURN_PROP_CASE(PR_ORIGINATOR_ENTRYID);
        RETURN_PROP_CASE(PR_ARRIVAL_TIME);
        RETURN_PROP_CASE(PR_TRACE_INFO)
        RETURN_PROP_CASE(PR_INTERNAL_TRACE_INFO)
        RETURN_PROP_CASE(PR_SUBJECT_TRACE_INFO)
        RETURN_PROP_CASE(PR_RECIPIENT_NUMBER);
        RETURN_PROP_CASE(PR_MTS_SUBJECT_ID);
        RETURN_PROP_CASE(PR_REPORT_DESTINATION_NAME);
        RETURN_PROP_CASE(PR_REPORT_DESTINATION_ENTRYID);
        RETURN_PROP_CASE(PR_CONTENT_SEARCH_KEY);
        RETURN_PROP_CASE(PR_FOREIGN_ID);
        RETURN_PROP_CASE(PR_FOREIGN_REPORT_ID);
        RETURN_PROP_CASE(PR_FOREIGN_SUBJECT_ID);
        RETURN_PROP_CASE(PR_PROMOTE_PROP_ID_LIST);
        //RETURN_PROP_CASE(PR_MTS_ID);
        //RETURN_PROP_CASE(PR_MTS_REPORT_ID);
        RETURN_PROP_CASE(PR_MEMBER_ID);
        RETURN_PROP_CASE(PR_MEMBER_NAME);
        //RETURN_PROP_CASE(PR_MEMBER_ENTRYID);
        RETURN_PROP_CASE(PR_MEMBER_RIGHTS);
        RETURN_PROP_CASE(PR_RULE_ID);
        RETURN_PROP_CASE(PR_RULE_IDS);
        RETURN_PROP_CASE(PR_RULE_SEQUENCE);
        RETURN_PROP_CASE(PR_RULE_STATE);
        RETURN_PROP_CASE(PR_RULE_USER_FLAGS);
        RETURN_PROP_CASE(PR_RULE_CONDITION);
        RETURN_PROP_CASE(PR_RULE_ACTIONS);
        RETURN_PROP_CASE(PR_RULE_PROVIDER);
        RETURN_PROP_CASE(PR_RULE_NAME);
        RETURN_PROP_CASE(PR_RULE_LEVEL);
        RETURN_PROP_CASE(PR_RULE_PROVIDER_DATA);
        //RETURN_PROP_CASE(PR_RULE_VERSION);

        RETURN_PROP_CASE(PR_NT_USER_NAME);
        RETURN_PROP_CASE(PR_LOCALE_ID);
        RETURN_PROP_CASE(PR_LAST_LOGON_TIME);
        RETURN_PROP_CASE(PR_LAST_LOGOFF_TIME);
        RETURN_PROP_CASE(PR_STORAGE_LIMIT_INFORMATION);
        RETURN_PROP_CASE(PR_FOLDER_FLAGS);
        RETURN_PROP_CASE(PR_LAST_ACCESS_TIME);
        RETURN_PROP_CASE(PR_RESTRICTION_COUNT);
        RETURN_PROP_CASE(PR_CATEG_COUNT);
        RETURN_PROP_CASE(PR_CACHED_COLUMN_COUNT);
        RETURN_PROP_CASE(PR_NORMAL_MSG_W_ATTACH_COUNT);
        RETURN_PROP_CASE(PR_ASSOC_MSG_W_ATTACH_COUNT);
        RETURN_PROP_CASE(PR_RECIPIENT_ON_NORMAL_MSG_COUNT);
        RETURN_PROP_CASE(PR_RECIPIENT_ON_ASSOC_MSG_COUNT);
        RETURN_PROP_CASE(PR_ATTACH_ON_NORMAL_MSG_COUNT);
        RETURN_PROP_CASE(PR_ATTACH_ON_ASSOC_MSG_COUNT);
        RETURN_PROP_CASE(PR_NORMAL_MESSAGE_SIZE);
        //RETURN_PROP_CASE(PR_NORMAL_MESSAGE_SIZE_EXTENDED);
        RETURN_PROP_CASE(PR_ASSOC_MESSAGE_SIZE);
        //RETURN_PROP_CASE(PR_ASSOC_MESSAGE_SIZE_EXTENDED);
        RETURN_PROP_CASE(PR_FOLDER_PATHNAME);
        RETURN_PROP_CASE(PR_OWNER_COUNT);
        RETURN_PROP_CASE(PR_CONTACT_COUNT);
        //RETURN_PROP_CASE(PR_LOCALE_ID);
        RETURN_PROP_CASE(PR_CODE_PAGE_ID);
        RETURN_PROP_CASE(PR_SORT_LOCALE_ID);
        //RETURN_PROP_CASE(PR_MESSAGE_SIZE_EXTENDED);

        RETURN_PROP_CASE(PR_AUTO_ADD_NEW_SUBS);
        RETURN_PROP_CASE(PR_NEW_SUBS_GET_AUTO_ADD);


        RETURN_PROP_CASE(PR_OFFLINE_FLAGS);
        RETURN_PROP_CASE(PR_SYNCHRONIZE_FLAGS);
        RETURN_PROP_CASE(PR_MESSAGE_SITE_NAME);
        RETURN_PROP_CASE(PR_MESSAGE_PROCESSED);
        RETURN_PROP_CASE(PR_MSG_BODY_ID);
        RETURN_PROP_CASE(PR_BILATERAL_INFO);
        RETURN_PROP_CASE(PR_DL_REPORT_FLAGS);
        RETURN_PROP_CASE(PR_ABSTRACT);
        RETURN_PROP_CASE(PR_PREVIEW);
        RETURN_PROP_CASE(PR_PREVIEW_UNREAD);
        RETURN_PROP_CASE(PR_DISABLE_FULL_FIDELITY);
        RETURN_PROP_CASE(PR_OWA_URL);
        RETURN_PROP_CASE(PR_STORE_SLOWLINK);
        //End <edkmdb.h>

        //<EMSAbTag.h>
        RETURN_PROP_CASE(PR_EMS_AB_SERVER);
        RETURN_PROP_CASE(PR_EMS_AB_CONTAINERID);
        RETURN_PROP_CASE(PR_EMS_AB_PARENT_ENTRYID);
        RETURN_PROP_CASE(PR_EMS_AB_IS_MASTER);
        RETURN_PROP_CASE(PR_EMS_AB_OBJECT_OID);
        RETURN_PROP_CASE(PR_EMS_AB_HIERARCHY_PATH);
        RETURN_PROP_CASE(PR_EMS_AB_CHILD_RDNS);
        RETURN_PROP_CASE(PR_EMS_AB_OTHER_RECIPS);
        //RETURN_PROP_CASE(PR_EMS_AB_DISPLAY_NAME_PRINTABLE);
        RETURN_PROP_CASE(PR_EMS_AB_ACCESS_CATEGORY);
        RETURN_PROP_CASE(PR_EMS_AB_ACTIVATION_SCHEDULE);
        RETURN_PROP_CASE(PR_EMS_AB_ACTIVATION_STYLE);
        RETURN_PROP_CASE(PR_EMS_AB_ADC_GLOBAL_NAMES);
        RETURN_PROP_CASE(PR_EMS_AB_ADDRESS_ENTRY_DISPLAY_TABLE);
        RETURN_PROP_CASE(PR_EMS_AB_ADDRESS_ENTRY_DISPLAY_TABLE_MSDOS);
        RETURN_PROP_CASE(PR_EMS_AB_ADDRESS_SYNTAX);
        RETURN_PROP_CASE(PR_EMS_AB_ADDRESS_TYPE);
        RETURN_PROP_CASE(PR_EMS_AB_ADMD);
        RETURN_PROP_CASE(PR_EMS_AB_ADMIN_DESCRIPTION);
        RETURN_PROP_CASE(PR_EMS_AB_ADMIN_DISPLAY_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_ADMIN_EXTENSION_DLL);
        RETURN_PROP_CASE(PR_EMS_AB_ALIASED_OBJECT_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_ALT_RECIPIENT);
        RETURN_PROP_CASE(PR_EMS_AB_ALT_RECIPIENT_BL);
        RETURN_PROP_CASE(PR_EMS_AB_ANCESTOR_ID);
        RETURN_PROP_CASE(PR_EMS_AB_ANONYMOUS_ACCESS);
        RETURN_PROP_CASE(PR_EMS_AB_ANONYMOUS_ACCOUNT);
        RETURN_PROP_CASE(PR_EMS_AB_ASSOCIATION_LIFETIME);
        RETURN_PROP_CASE(PR_EMS_AB_ASSOC_NT_ACCOUNT);
        RETURN_PROP_CASE(PR_EMS_AB_ASSOC_PROTOCOL_CFG_NNTP);
        RETURN_PROP_CASE(PR_EMS_AB_ASSOC_REMOTE_DXA);
        RETURN_PROP_CASE(PR_EMS_AB_ATTRIBUTE_CERTIFICATE);
        RETURN_PROP_CASE(PR_EMS_AB_AUTHENTICATION_TO_USE);
        RETURN_PROP_CASE(PR_EMS_AB_AUTH_ORIG_BL);
        RETURN_PROP_CASE(PR_EMS_AB_AUTHORITY_REVOCATION_LIST);
        RETURN_PROP_CASE(PR_EMS_AB_AUTHORIZED_DOMAIN);
        RETURN_PROP_CASE(PR_EMS_AB_AUTHORIZED_PASSWORD);
        RETURN_PROP_CASE(PR_EMS_AB_AUTHORIZED_PASSWORD_CONFIRM);
        RETURN_PROP_CASE(PR_EMS_AB_AUTHORIZED_USER);
        RETURN_PROP_CASE(PR_EMS_AB_AUTOREPLY);
        RETURN_PROP_CASE(PR_EMS_AB_AUTOREPLY_MESSAGE);
        RETURN_PROP_CASE(PR_EMS_AB_AUTOREPLY_SUBJECT);
        RETURN_PROP_CASE(PR_EMS_AB_AVAILABLE_AUTHORIZATION_PACKAGES);
        RETURN_PROP_CASE(PR_EMS_AB_AVAILABLE_DISTRIBUTIONS);
        RETURN_PROP_CASE(PR_EMS_AB_BRIDGEHEAD_SERVERS);
        RETURN_PROP_CASE(PR_EMS_AB_BUSINESS_CATEGORY);
        RETURN_PROP_CASE(PR_EMS_AB_BUSINESS_ROLES);
        RETURN_PROP_CASE(PR_EMS_AB_CA_CERTIFICATE);
        RETURN_PROP_CASE(PR_EMS_AB_CAN_CREATE_PF);
        RETURN_PROP_CASE(PR_EMS_AB_CAN_CREATE_PF_BL);
        RETURN_PROP_CASE(PR_EMS_AB_CAN_CREATE_PF_DL);
        RETURN_PROP_CASE(PR_EMS_AB_CAN_CREATE_PF_DL_BL);
        RETURN_PROP_CASE(PR_EMS_AB_CAN_NOT_CREATE_PF);
        RETURN_PROP_CASE(PR_EMS_AB_CAN_NOT_CREATE_PF_BL);
        RETURN_PROP_CASE(PR_EMS_AB_CAN_NOT_CREATE_PF_DL);
        RETURN_PROP_CASE(PR_EMS_AB_CAN_NOT_CREATE_PF_DL_BL);
        RETURN_PROP_CASE(PR_EMS_AB_CAN_PRESERVE_DNS);
        RETURN_PROP_CASE(PR_EMS_AB_CERTIFICATE_CHAIN_V3);
        RETURN_PROP_CASE(PR_EMS_AB_CERTIFICATE_REVOCATION_LIST);
        RETURN_PROP_CASE(PR_EMS_AB_CERTIFICATE_REVOCATION_LIST_V1);
        RETURN_PROP_CASE(PR_EMS_AB_CERTIFICATE_REVOCATION_LIST_V3);
        RETURN_PROP_CASE(PR_EMS_AB_CHARACTER_SET);
        RETURN_PROP_CASE(PR_EMS_AB_CHARACTER_SET_LIST);
        RETURN_PROP_CASE(PR_EMS_AB_CLIENT_ACCESS_ENABLED);
        RETURN_PROP_CASE(PR_EMS_AB_CLOCK_ALERT_OFFSET);
        RETURN_PROP_CASE(PR_EMS_AB_CLOCK_ALERT_REPAIR);
        RETURN_PROP_CASE(PR_EMS_AB_CLOCK_WARNING_OFFSET);
        RETURN_PROP_CASE(PR_EMS_AB_CLOCK_WARNING_REPAIR);
        RETURN_PROP_CASE(PR_EMS_AB_COMPROMISED_KEY_LIST);
        RETURN_PROP_CASE(PR_EMS_AB_COMPUTER_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_CONNECTED_DOMAINS);
        RETURN_PROP_CASE(PR_EMS_AB_CONNECTION_LIST_FILTER);
        RETURN_PROP_CASE(PR_EMS_AB_CONNECTION_LIST_FILTER_TYPE);
        RETURN_PROP_CASE(PR_EMS_AB_CONNECTION_TYPE);
        RETURN_PROP_CASE(PR_EMS_AB_CONTAINER_INFO);
        RETURN_PROP_CASE(PR_EMS_AB_CONTENT_TYPE);
        RETURN_PROP_CASE(PR_EMS_AB_CONTROL_MSG_FOLDER_ID);
        RETURN_PROP_CASE(PR_EMS_AB_CONTROL_MSG_RULES);
        RETURN_PROP_CASE(PR_EMS_AB_COST);
        RETURN_PROP_CASE(PR_EMS_AB_COUNTRY_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_CROSS_CERTIFICATE_CRL);
        RETURN_PROP_CASE(PR_EMS_AB_CROSS_CERTIFICATE_PAIR);
        RETURN_PROP_CASE(PR_EMS_AB_DEFAULT_MESSAGE_FORMAT);
        RETURN_PROP_CASE(PR_EMS_AB_DELEGATE_USER);
        RETURN_PROP_CASE(PR_EMS_AB_DELIV_CONT_LENGTH);
        RETURN_PROP_CASE(PR_EMS_AB_DELIV_EITS);
        RETURN_PROP_CASE(PR_EMS_AB_DELIVER_AND_REDIRECT);
        RETURN_PROP_CASE(PR_EMS_AB_DELIVERY_MECHANISM);
        RETURN_PROP_CASE(PR_EMS_AB_DELIV_EXT_CONT_TYPES);
        RETURN_PROP_CASE(PR_EMS_AB_DELTA_REVOCATION_LIST);
        RETURN_PROP_CASE(PR_EMS_AB_DESCRIPTION);
        RETURN_PROP_CASE(PR_EMS_AB_DESTINATION_INDICATOR);
        RETURN_PROP_CASE(PR_EMS_AB_DIAGNOSTIC_REG_KEY);
        RETURN_PROP_CASE(PR_EMS_AB_DISABLE_DEFERRED_COMMIT);
        RETURN_PROP_CASE(PR_EMS_AB_DISABLED_GATEWAY_PROXY);
        RETURN_PROP_CASE(PR_EMS_AB_DISPLAY_NAME_OVERRIDE);
        RETURN_PROP_CASE(PR_EMS_AB_DISPLAY_NAME_SUFFIX);
        RETURN_PROP_CASE(PR_EMS_AB_DL_MEMBER_RULE);
        RETURN_PROP_CASE(PR_EMS_AB_DL_MEM_REJECT_PERMS_BL);
        RETURN_PROP_CASE(PR_EMS_AB_DL_MEM_SUBMIT_PERMS_BL);
        RETURN_PROP_CASE(PR_EMS_AB_DMD_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_DOMAIN_DEF_ALT_RECIP);
        RETURN_PROP_CASE(PR_EMS_AB_DOMAIN_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_DO_OAB_VERSION);
        RETURN_PROP_CASE(PR_EMS_AB_DSA_SIGNATURE);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_ADMIN_COPY);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_ADMIN_FORWARD);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_ADMIN_UPDATE);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_APPEND_REQCN);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_CONF_CONTAINER_LIST);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_CONF_CONTAINER_LIST_BL);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_CONF_CONTAINER_LIST_LINKED);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_CONF_REQ_TIME);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_CONF_SEQ);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_CONF_SEQ_USN);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_EXCHANGE_OPTIONS);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_EXPORT_NOW);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_FLAGS);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_IMPORT_NOW);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_IMP_SEQ);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_IMP_SEQ_TIME);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_IMP_SEQ_USN);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_IN_TEMPLATE_MAP);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_LOCAL_ADMIN);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_LOGGING_LEVEL);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_NATIVE_ADDRESS_TYPE);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_OUT_TEMPLATE_MAP);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_PASSWORD);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_PREV_EXCHANGE_OPTIONS);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_PREV_EXPORT_NATIVE_ONLY);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_PREV_IN_EXCHANGE_SENSITIVITY);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_PREV_REMOTE_ENTRIES);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_PREV_REPLICATION_SENSITIVITY);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_PREV_TEMPLATE_OPTIONS);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_PREV_TYPES);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_RECIPIENT_CP);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_REMOTE_CLIENT);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_REQNAME);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_REQ_SEQ);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_REQ_SEQ_TIME);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_REQ_SEQ_USN);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_SVR_SEQ);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_SVR_SEQ_TIME);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_SVR_SEQ_USN);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_TASK);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_TEMPLATE_OPTIONS);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_TEMPLATE_TIMESTAMP);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_TYPES);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_UNCONF_CONTAINER_LIST);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_UNCONF_CONTAINER_LIST_BL);
        RETURN_PROP_CASE(PR_EMS_AB_DXA_UNCONF_CONTAINER_LIST_LINKED);
        RETURN_PROP_CASE(PR_EMS_AB_EMPLOYEE_NUMBER);
        RETURN_PROP_CASE(PR_EMS_AB_EMPLOYEE_TYPE);
        RETURN_PROP_CASE(PR_EMS_AB_ENABLE_COMPATIBILITY);
        RETURN_PROP_CASE(PR_EMS_AB_ENABLED);
        RETURN_PROP_CASE(PR_EMS_AB_ENABLED_AUTHORIZATION_PACKAGES);
        RETURN_PROP_CASE(PR_EMS_AB_ENABLED_PROTOCOL_CFG);
        RETURN_PROP_CASE(PR_EMS_AB_ENABLED_PROTOCOLS);
        RETURN_PROP_CASE(PR_EMS_AB_ENCAPSULATION_METHOD);
        RETURN_PROP_CASE(PR_EMS_AB_ENCRYPT);
        RETURN_PROP_CASE(PR_EMS_AB_ENCRYPT_ALG_LIST_NA);
        RETURN_PROP_CASE(PR_EMS_AB_ENCRYPT_ALG_LIST_OTHER);
        RETURN_PROP_CASE(PR_EMS_AB_ENCRYPT_ALG_SELECTED_NA);
        RETURN_PROP_CASE(PR_EMS_AB_ENCRYPT_ALG_SELECTED_OTHER);
        RETURN_PROP_CASE(PR_EMS_AB_EXPAND_DLS_LOCALLY);
        RETURN_PROP_CASE(PR_EMS_AB_EXPIRATION_TIME);
        RETURN_PROP_CASE(PR_EMS_AB_EXPORT_CONTAINERS);
        RETURN_PROP_CASE(PR_EMS_AB_EXPORT_CUSTOM_RECIPIENTS);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENDED_CHARS_ALLOWED);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_1);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_10);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_11);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_12);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_13);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_14);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_15);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_2);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_3);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_4);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_5);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_6);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_7);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_8);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_9);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_DATA);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_NAME_INHERITED);
        RETURN_PROP_CASE(PR_EMS_AB_FACSIMILE_TELEPHONE_NUMBER);
        RETURN_PROP_CASE(PR_EMS_AB_FILE_VERSION);
        RETURN_PROP_CASE(PR_EMS_AB_FILTER_LOCAL_ADDRESSES);
        RETURN_PROP_CASE(PR_EMS_AB_FOLDER_PATHNAME);
        RETURN_PROP_CASE(PR_EMS_AB_FOLDERS_CONTAINER);
        RETURN_PROP_CASE(PR_EMS_AB_FORM_DATA);
        RETURN_PROP_CASE(PR_EMS_AB_FORWARDING_ADDRESS);
        RETURN_PROP_CASE(PR_EMS_AB_GARBAGE_COLL_PERIOD);
        RETURN_PROP_CASE(PR_EMS_AB_GATEWAY_LOCAL_CRED);
        RETURN_PROP_CASE(PR_EMS_AB_GATEWAY_LOCAL_DESIG);
        RETURN_PROP_CASE(PR_EMS_AB_GATEWAY_PROXY);
        RETURN_PROP_CASE(PR_EMS_AB_GATEWAY_ROUTING_TREE);
        RETURN_PROP_CASE(PR_EMS_AB_GENERATION_QUALIFIER);
        RETURN_PROP_CASE(PR_EMS_AB_GROUP_BY_ATTR_1);
        RETURN_PROP_CASE(PR_EMS_AB_GROUP_BY_ATTR_2);
        RETURN_PROP_CASE(PR_EMS_AB_GROUP_BY_ATTR_3);
        RETURN_PROP_CASE(PR_EMS_AB_GROUP_BY_ATTR_4);
        RETURN_PROP_CASE(PR_EMS_AB_GROUP_BY_ATTR_VALUE_DN);
        RETURN_PROP_CASE(PR_EMS_AB_GROUP_BY_ATTR_VALUE_STR);
        RETURN_PROP_CASE(PR_EMS_AB_GWART_LAST_MODIFIED);
        RETURN_PROP_CASE(PR_EMS_AB_HAS_FULL_REPLICA_NCS);
        RETURN_PROP_CASE(PR_EMS_AB_HAS_MASTER_NCS);
        RETURN_PROP_CASE(PR_EMS_AB_HELP_DATA16);
        RETURN_PROP_CASE(PR_EMS_AB_HELP_DATA32);
        RETURN_PROP_CASE(PR_EMS_AB_HELP_FILE_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_HEURISTICS);
        RETURN_PROP_CASE(PR_EMS_AB_HIDE_DL_MEMBERSHIP);
        RETURN_PROP_CASE(PR_EMS_AB_HIDE_FROM_ADDRESS_BOOK);
        RETURN_PROP_CASE(PR_EMS_AB_HOME_MDB);
        RETURN_PROP_CASE(PR_EMS_AB_HOME_MDB_BL);
        RETURN_PROP_CASE(PR_EMS_AB_HOME_MTA);
        RETURN_PROP_CASE(PR_EMS_AB_HOME_PUBLIC_SERVER);
        RETURN_PROP_CASE(PR_EMS_AB_HOUSE_IDENTIFIER);
        RETURN_PROP_CASE(PR_EMS_AB_HTTP_PUB_AB_ATTRIBUTES);
        RETURN_PROP_CASE(PR_EMS_AB_HTTP_PUB_GAL);
        RETURN_PROP_CASE(PR_EMS_AB_HTTP_PUB_GAL_LIMIT);
        RETURN_PROP_CASE(PR_EMS_AB_HTTP_PUB_PF);
        RETURN_PROP_CASE(PR_EMS_AB_HTTP_SERVERS);
        RETURN_PROP_CASE(PR_EMS_AB_IMPORT_CONTAINER);
        RETURN_PROP_CASE(PR_EMS_AB_IMPORTED_FROM);
        RETURN_PROP_CASE(PR_EMS_AB_IMPORT_SENSITIVITY);
        RETURN_PROP_CASE(PR_EMS_AB_INBOUND_ACCEPT_ALL);
        RETURN_PROP_CASE(PR_EMS_AB_INBOUND_DN);
        RETURN_PROP_CASE(PR_EMS_AB_INBOUND_HOST);
        RETURN_PROP_CASE(PR_EMS_AB_INBOUND_NEWSFEED);
        RETURN_PROP_CASE(PR_EMS_AB_INBOUND_NEWSFEED_TYPE);
        RETURN_PROP_CASE(PR_EMS_AB_INBOUND_SITES);
        RETURN_PROP_CASE(PR_EMS_AB_INCOMING_MSG_SIZE_LIMIT);
        RETURN_PROP_CASE(PR_EMS_AB_INCOMING_PASSWORD);
        RETURN_PROP_CASE(PR_EMS_AB_INSADMIN);
        RETURN_PROP_CASE(PR_EMS_AB_INSTANCE_TYPE);
        RETURN_PROP_CASE(PR_EMS_AB_INTERNATIONAL_ISDN_NUMBER);
        RETURN_PROP_CASE(PR_EMS_AB_INVOCATION_ID);
        RETURN_PROP_CASE(PR_EMS_AB_IS_DELETED);
        RETURN_PROP_CASE(PR_EMS_AB_IS_MEMBER_OF_DL);
        RETURN_PROP_CASE(PR_EMS_AB_IS_SINGLE_VALUED);
        RETURN_PROP_CASE(PR_EMS_AB_KCC_STATUS);
        RETURN_PROP_CASE(PR_EMS_AB_KM_SERVER);
        RETURN_PROP_CASE(PR_EMS_AB_KNOWLEDGE_INFORMATION);
        RETURN_PROP_CASE(PR_EMS_AB_LABELEDURI);
        RETURN_PROP_CASE(PR_EMS_AB_LANGUAGE);
        RETURN_PROP_CASE(PR_EMS_AB_LANGUAGE_ISO639);
        RETURN_PROP_CASE(PR_EMS_AB_LDAP_DISPLAY_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_LDAP_SEARCH_CFG);
        RETURN_PROP_CASE(PR_EMS_AB_LINE_WRAP);
        RETURN_PROP_CASE(PR_EMS_AB_LINK_ID);
        RETURN_PROP_CASE(PR_EMS_AB_LIST_PUBLIC_FOLDERS);
        RETURN_PROP_CASE(PR_EMS_AB_LOCAL_BRIDGE_HEAD);
        RETURN_PROP_CASE(PR_EMS_AB_LOCAL_BRIDGE_HEAD_ADDRESS);
        RETURN_PROP_CASE(PR_EMS_AB_LOCAL_INITIAL_TURN);
        RETURN_PROP_CASE(PR_EMS_AB_LOCAL_SCOPE);
        RETURN_PROP_CASE(PR_EMS_AB_LOG_FILENAME);
        RETURN_PROP_CASE(PR_EMS_AB_LOG_ROLLOVER_INTERVAL);
        RETURN_PROP_CASE(PR_EMS_AB_MAIL_DROP);
        RETURN_PROP_CASE(PR_EMS_AB_MAINTAIN_AUTOREPLY_HISTORY);
        RETURN_PROP_CASE(PR_EMS_AB_MANAGER);
        RETURN_PROP_CASE(PR_EMS_AB_MAPI_DISPLAY_TYPE);
        RETURN_PROP_CASE(PR_EMS_AB_MAPI_ID);
        RETURN_PROP_CASE(PR_EMS_AB_MAXIMUM_OBJECT_ID);
        RETURN_PROP_CASE(PR_EMS_AB_MDB_BACKOFF_INTERVAL);
        RETURN_PROP_CASE(PR_EMS_AB_MDB_MSG_TIME_OUT_PERIOD);
        RETURN_PROP_CASE(PR_EMS_AB_MDB_OVER_QUOTA_LIMIT);
        RETURN_PROP_CASE(PR_EMS_AB_MDB_STORAGE_QUOTA);
        RETURN_PROP_CASE(PR_EMS_AB_MDB_UNREAD_LIMIT);
        RETURN_PROP_CASE(PR_EMS_AB_MDB_USE_DEFAULTS);
        RETURN_PROP_CASE(PR_EMS_AB_MEMBER);
        RETURN_PROP_CASE(PR_EMS_AB_MESSAGE_TRACKING_ENABLED);
        RETURN_PROP_CASE(PR_EMS_AB_MIME_TYPES);
        RETURN_PROP_CASE(PR_EMS_AB_MODERATED);
        RETURN_PROP_CASE(PR_EMS_AB_MODERATOR);
        RETURN_PROP_CASE(PR_EMS_AB_MONITOR_CLOCK);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORED_CONFIGURATIONS);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORED_SERVERS);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORED_SERVICES);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_ALERT_DELAY);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_ALERT_UNITS);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_AVAILABILITY_STYLE);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_AVAILABILITY_WINDOW);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_CACHED_VIA_MAIL);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_CACHED_VIA_RPC);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_ESCALATION_PROCEDURE);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_HOTSITE_POLL_INTERVAL);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_HOTSITE_POLL_UNITS);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_MAIL_UPDATE_INTERVAL);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_MAIL_UPDATE_UNITS);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_NORMAL_POLL_INTERVAL);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_NORMAL_POLL_UNITS);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_RECIPIENTS);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_RECIPIENTS_NDR);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_RPC_UPDATE_INTERVAL);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_RPC_UPDATE_UNITS);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_WARNING_DELAY);
        RETURN_PROP_CASE(PR_EMS_AB_MONITORING_WARNING_UNITS);
        RETURN_PROP_CASE(PR_EMS_AB_MONITOR_SERVERS);
        RETURN_PROP_CASE(PR_EMS_AB_MONITOR_SERVICES);
        RETURN_PROP_CASE(PR_EMS_AB_MTA_LOCAL_CRED);
        RETURN_PROP_CASE(PR_EMS_AB_MTA_LOCAL_DESIG);
        RETURN_PROP_CASE(PR_EMS_AB_N_ADDRESS);
        RETURN_PROP_CASE(PR_EMS_AB_N_ADDRESS_TYPE);
        RETURN_PROP_CASE(PR_EMS_AB_NETWORK_ADDRESS);
        RETURN_PROP_CASE(PR_EMS_AB_NEWSFEED_TYPE);
        RETURN_PROP_CASE(PR_EMS_AB_NEWSGROUP);
        RETURN_PROP_CASE(PR_EMS_AB_NEWSGROUP_LIST);
        RETURN_PROP_CASE(PR_EMS_AB_NNTP_CHARACTER_SET);
        RETURN_PROP_CASE(PR_EMS_AB_NNTP_CONTENT_FORMAT);
        RETURN_PROP_CASE(PR_EMS_AB_NNTP_DISTRIBUTIONS);
        RETURN_PROP_CASE(PR_EMS_AB_NNTP_DISTRIBUTIONS_FLAG);
        RETURN_PROP_CASE(PR_EMS_AB_NNTP_NEWSFEEDS);
        RETURN_PROP_CASE(PR_EMS_AB_NT_MACHINE_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_NT_SECURITY_DESCRIPTOR);
        RETURN_PROP_CASE(PR_EMS_AB_NUM_OF_OPEN_RETRIES);
        RETURN_PROP_CASE(PR_EMS_AB_NUM_OF_TRANSFER_RETRIES);
        RETURN_PROP_CASE(PR_EMS_AB_OBJ_DIST_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_OBJECT_CLASS_CATEGORY);
        RETURN_PROP_CASE(PR_EMS_AB_OBJECT_GUID);
        RETURN_PROP_CASE(PR_EMS_AB_OBJECT_VERSION);
        RETURN_PROP_CASE(PR_EMS_AB_OBJ_VIEW_CONTAINERS);
        RETURN_PROP_CASE(PR_EMS_AB_OFF_LINE_AB_CONTAINERS);
        RETURN_PROP_CASE(PR_EMS_AB_OFF_LINE_AB_SCHEDULE);
        RETURN_PROP_CASE(PR_EMS_AB_OFF_LINE_AB_SERVER);
        RETURN_PROP_CASE(PR_EMS_AB_OFF_LINE_AB_STYLE);
        RETURN_PROP_CASE(PR_EMS_AB_OID_TYPE);
        RETURN_PROP_CASE(PR_EMS_AB_OM_OBJECT_CLASS);
        RETURN_PROP_CASE(PR_EMS_AB_OM_SYNTAX);
        RETURN_PROP_CASE(PR_EMS_AB_OOF_REPLY_TO_ORIGINATOR);
        RETURN_PROP_CASE(PR_EMS_AB_OPEN_RETRY_INTERVAL);
        RETURN_PROP_CASE(PR_EMS_AB_ORGANIZATIONAL_UNIT_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_ORGANIZATION_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_ORIGINAL_DISPLAY_TABLE);
        RETURN_PROP_CASE(PR_EMS_AB_ORIGINAL_DISPLAY_TABLE_MSDOS);
        RETURN_PROP_CASE(PR_EMS_AB_OUTBOUND_HOST);
        RETURN_PROP_CASE(PR_EMS_AB_OUTBOUND_HOST_TYPE);
        RETURN_PROP_CASE(PR_EMS_AB_OUTBOUND_NEWSFEED);
        RETURN_PROP_CASE(PR_EMS_AB_OUTBOUND_SITES);
        RETURN_PROP_CASE(PR_EMS_AB_OUTGOING_MSG_SIZE_LIMIT);
        RETURN_PROP_CASE(PR_EMS_AB_OVERRIDE_NNTP_CONTENT_FORMAT);
        RETURN_PROP_CASE(PR_EMS_AB_OWA_SERVER);
        RETURN_PROP_CASE(PR_EMS_AB_OWNER);
        RETURN_PROP_CASE(PR_EMS_AB_OWNER_BL);
        RETURN_PROP_CASE(PR_EMS_AB_PERIOD_REPL_STAGGER);
        RETURN_PROP_CASE(PR_EMS_AB_PERIOD_REP_SYNC_TIMES);
        RETURN_PROP_CASE(PR_EMS_AB_PER_MSG_DIALOG_DISPLAY_TABLE);
        RETURN_PROP_CASE(PR_EMS_AB_PER_RECIP_DIALOG_DISPLAY_TABLE);
        RETURN_PROP_CASE(PR_EMS_AB_PERSONAL_TITLE);
        RETURN_PROP_CASE(PR_EMS_AB_PF_CONTACTS);
        RETURN_PROP_CASE(PR_EMS_AB_POP_CHARACTER_SET);
        RETURN_PROP_CASE(PR_EMS_AB_POP_CONTENT_FORMAT);
        RETURN_PROP_CASE(PR_EMS_AB_PORT_NUMBER);
        RETURN_PROP_CASE(PR_EMS_AB_POSTAL_ADDRESS);
        RETURN_PROP_CASE(PR_EMS_AB_PREFERRED_DELIVERY_METHOD);
        RETURN_PROP_CASE(PR_EMS_AB_PRESERVE_INTERNET_CONTENT);
        RETURN_PROP_CASE(PR_EMS_AB_PRMD);
        RETURN_PROP_CASE(PR_EMS_AB_PROMO_EXPIRATION);
        RETURN_PROP_CASE(PR_EMS_AB_PROTOCOL_SETTINGS);
        RETURN_PROP_CASE(PR_EMS_AB_PROXY_ADDRESSES);
        RETURN_PROP_CASE(PR_EMS_AB_PROXY_GENERATION_ENABLED);
        RETURN_PROP_CASE(PR_EMS_AB_PROXY_GENERATOR_DLL);
        RETURN_PROP_CASE(PR_EMS_AB_P_SELECTOR);
        RETURN_PROP_CASE(PR_EMS_AB_P_SELECTOR_INBOUND);
        RETURN_PROP_CASE(PR_EMS_AB_PUBLIC_DELEGATES);
        RETURN_PROP_CASE(PR_EMS_AB_PUBLIC_DELEGATES_BL);
        RETURN_PROP_CASE(PR_EMS_AB_QUOTA_NOTIFICATION_SCHEDULE);
        RETURN_PROP_CASE(PR_EMS_AB_QUOTA_NOTIFICATION_STYLE);
        RETURN_PROP_CASE(PR_EMS_AB_RANGE_LOWER);
        RETURN_PROP_CASE(PR_EMS_AB_RANGE_UPPER);
        RETURN_PROP_CASE(PR_EMS_AB_RAS_ACCOUNT);
        RETURN_PROP_CASE(PR_EMS_AB_RAS_CALLBACK_NUMBER);
        RETURN_PROP_CASE(PR_EMS_AB_RAS_PASSWORD);
        RETURN_PROP_CASE(PR_EMS_AB_RAS_PHONEBOOK_ENTRY_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_RAS_PHONE_NUMBER);
        RETURN_PROP_CASE(PR_EMS_AB_RAS_REMOTE_SRVR_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_REFERRAL_LIST);
        RETURN_PROP_CASE(PR_EMS_AB_REGISTERED_ADDRESS);
        RETURN_PROP_CASE(PR_EMS_AB_REMOTE_BRIDGE_HEAD);
        RETURN_PROP_CASE(PR_EMS_AB_REMOTE_BRIDGE_HEAD_ADDRESS);
        RETURN_PROP_CASE(PR_EMS_AB_REMOTE_OUT_BH_SERVER);
        RETURN_PROP_CASE(PR_EMS_AB_REMOTE_SITE);
        RETURN_PROP_CASE(PR_EMS_AB_REPLICATED_OBJECT_VERSION);
        RETURN_PROP_CASE(PR_EMS_AB_REPLICATION_MAIL_MSG_SIZE);
        RETURN_PROP_CASE(PR_EMS_AB_REPLICATION_SENSITIVITY);
        RETURN_PROP_CASE(PR_EMS_AB_REPLICATION_SIGNATURE);
        RETURN_PROP_CASE(PR_EMS_AB_REPLICATION_STAGGER);
        RETURN_PROP_CASE(PR_EMS_AB_REPORTS);
        RETURN_PROP_CASE(PR_EMS_AB_REPORT_TO_ORIGINATOR);
        RETURN_PROP_CASE(PR_EMS_AB_REPORT_TO_OWNER);
        RETURN_PROP_CASE(PR_EMS_AB_REQ_SEQ);
        RETURN_PROP_CASE(PR_EMS_AB_REQUIRE_SSL);
        RETURN_PROP_CASE(PR_EMS_AB_RESPONSIBLE_LOCAL_DXA);
        RETURN_PROP_CASE(PR_EMS_AB_RETURN_EXACT_MSG_SIZE);
        RETURN_PROP_CASE(PR_EMS_AB_RID_SERVER);
        RETURN_PROP_CASE(PR_EMS_AB_ROLE_OCCUPANT);
        RETURN_PROP_CASE(PR_EMS_AB_ROOT_NEWSGROUPS_FOLDER_ID);
        RETURN_PROP_CASE(PR_EMS_AB_ROUTING_LIST);
        RETURN_PROP_CASE(PR_EMS_AB_RTS_CHECKPOINT_SIZE);
        RETURN_PROP_CASE(PR_EMS_AB_RTS_RECOVERY_TIMEOUT);
        RETURN_PROP_CASE(PR_EMS_AB_RTS_WINDOW_SIZE);
        RETURN_PROP_CASE(PR_EMS_AB_RUNS_ON);
        RETURN_PROP_CASE(PR_EMS_AB_SCHEMA_FLAGS);
        RETURN_PROP_CASE(PR_EMS_AB_SCHEMA_VERSION);
        RETURN_PROP_CASE(PR_EMS_AB_SEARCH_FLAGS);
        RETURN_PROP_CASE(PR_EMS_AB_SEARCH_GUIDE);
        RETURN_PROP_CASE(PR_EMS_AB_SECURITY_POLICY);
        RETURN_PROP_CASE(PR_EMS_AB_SECURITY_PROTOCOL);
        RETURN_PROP_CASE(PR_EMS_AB_SEE_ALSO);
        RETURN_PROP_CASE(PR_EMS_AB_SEND_EMAIL_MESSAGE);
        RETURN_PROP_CASE(PR_EMS_AB_SEND_TNEF);
        RETURN_PROP_CASE(PR_EMS_AB_SERIAL_NUMBER);
        RETURN_PROP_CASE(PR_EMS_AB_SERVICE_ACTION_FIRST);
        RETURN_PROP_CASE(PR_EMS_AB_SERVICE_ACTION_OTHER);
        RETURN_PROP_CASE(PR_EMS_AB_SERVICE_ACTION_SECOND);
        RETURN_PROP_CASE(PR_EMS_AB_SERVICE_RESTART_DELAY);
        RETURN_PROP_CASE(PR_EMS_AB_SERVICE_RESTART_MESSAGE);
        RETURN_PROP_CASE(PR_EMS_AB_SESSION_DISCONNECT_TIMER);
        RETURN_PROP_CASE(PR_EMS_AB_SITE_AFFINITY);
        RETURN_PROP_CASE(PR_EMS_AB_SITE_FOLDER_GUID);
        RETURN_PROP_CASE(PR_EMS_AB_SITE_FOLDER_SERVER);
        RETURN_PROP_CASE(PR_EMS_AB_SITE_PROXY_SPACE);
        RETURN_PROP_CASE(PR_EMS_AB_SMIME_ALG_LIST_NA);
        RETURN_PROP_CASE(PR_EMS_AB_SMIME_ALG_LIST_OTHER);
        RETURN_PROP_CASE(PR_EMS_AB_SMIME_ALG_SELECTED_NA);
        RETURN_PROP_CASE(PR_EMS_AB_SMIME_ALG_SELECTED_OTHER);
        RETURN_PROP_CASE(PR_EMS_AB_SPACE_LAST_COMPUTED);
        RETURN_PROP_CASE(PR_EMS_AB_S_SELECTOR);
        RETURN_PROP_CASE(PR_EMS_AB_S_SELECTOR_INBOUND);
        RETURN_PROP_CASE(PR_EMS_AB_STREET_ADDRESS);
        RETURN_PROP_CASE(PR_EMS_AB_SUBMISSION_CONT_LENGTH);
        RETURN_PROP_CASE(PR_EMS_AB_SUB_REFS);
        RETURN_PROP_CASE(PR_EMS_AB_SUB_SITE);
        RETURN_PROP_CASE(PR_EMS_AB_SUPPORTED_ALGORITHMS);
        RETURN_PROP_CASE(PR_EMS_AB_SUPPORTED_APPLICATION_CONTEXT);
        RETURN_PROP_CASE(PR_EMS_AB_SUPPORTING_STACK);
        RETURN_PROP_CASE(PR_EMS_AB_SUPPORTING_STACK_BL);
        RETURN_PROP_CASE(PR_EMS_AB_SUPPORT_SMIME_SIGNATURES);
        RETURN_PROP_CASE(PR_EMS_AB_TARGET_ADDRESS);
        RETURN_PROP_CASE(PR_EMS_AB_TARGET_MTAS);
        RETURN_PROP_CASE(PR_EMS_AB_TELEPHONE_NUMBER);
        RETURN_PROP_CASE(PR_EMS_AB_TELEPHONE_PERSONAL_PAGER);
        RETURN_PROP_CASE(PR_EMS_AB_TELETEX_TERMINAL_IDENTIFIER);
        RETURN_PROP_CASE(PR_EMS_AB_TEMP_ASSOC_THRESHOLD);
        RETURN_PROP_CASE(PR_EMS_AB_TOMBSTONE_LIFETIME);
        RETURN_PROP_CASE(PR_EMS_AB_TRACKING_LOG_PATH_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_TRANSFER_RETRY_INTERVAL);
        RETURN_PROP_CASE(PR_EMS_AB_TRANSFER_TIMEOUT_NON_URGENT);
        RETURN_PROP_CASE(PR_EMS_AB_TRANSFER_TIMEOUT_NORMAL);
        RETURN_PROP_CASE(PR_EMS_AB_TRANSFER_TIMEOUT_URGENT);
        RETURN_PROP_CASE(PR_EMS_AB_TRANSLATION_TABLE_USED);
        RETURN_PROP_CASE(PR_EMS_AB_TRANSPORT_EXPEDITED_DATA);
        RETURN_PROP_CASE(PR_EMS_AB_TRANS_RETRY_MINS);
        RETURN_PROP_CASE(PR_EMS_AB_TRANS_TIMEOUT_MINS);
        RETURN_PROP_CASE(PR_EMS_AB_TRUST_LEVEL);
        RETURN_PROP_CASE(PR_EMS_AB_T_SELECTOR);
        RETURN_PROP_CASE(PR_EMS_AB_T_SELECTOR_INBOUND);
        RETURN_PROP_CASE(PR_EMS_AB_TURN_REQUEST_THRESHOLD);
        RETURN_PROP_CASE(PR_EMS_AB_TWO_WAY_ALTERNATE_FACILITY);
        RETURN_PROP_CASE(PR_EMS_AB_TYPE);
        RETURN_PROP_CASE(PR_EMS_AB_UNAUTH_ORIG_BL);
        RETURN_PROP_CASE(PR_EMS_AB_UNMERGED_ATTRIBUTES);
        RETURN_PROP_CASE(PR_EMS_AB_USENET_SITE_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_USER_PASSWORD);
        RETURN_PROP_CASE(PR_EMS_AB_USE_SERVER_VALUES);
        RETURN_PROP_CASE(PR_EMS_AB_USE_SITE_VALUES);
        RETURN_PROP_CASE(PR_EMS_AB_USN_CHANGED);
        RETURN_PROP_CASE(PR_EMS_AB_USN_CREATED);
        RETURN_PROP_CASE(PR_EMS_AB_USN_DSA_LAST_OBJ_REMOVED);
        RETURN_PROP_CASE(PR_EMS_AB_USN_INTERSITE);
        RETURN_PROP_CASE(PR_EMS_AB_USN_LAST_OBJ_REM);
        RETURN_PROP_CASE(PR_EMS_AB_USN_SOURCE);
        RETURN_PROP_CASE(PR_EMS_AB_VIEW_CONTAINER_1);
        RETURN_PROP_CASE(PR_EMS_AB_VIEW_CONTAINER_2);
        RETURN_PROP_CASE(PR_EMS_AB_VIEW_CONTAINER_3);
        RETURN_PROP_CASE(PR_EMS_AB_VIEW_DEFINITION);
        RETURN_PROP_CASE(PR_EMS_AB_VIEW_FLAGS);
        RETURN_PROP_CASE(PR_EMS_AB_VIEW_SITE);
        RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_FLAGS);
        RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_GREETINGS);
        RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_PASSWORD);
        RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_RECORDED_NAME);
        RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_RECORDING_LENGTH);
        RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_SPEED);
        RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_SYSTEM_GUID);
        RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_USER_ID);
        RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_VOLUME);
        RETURN_PROP_CASE(PR_EMS_AB_WWW_HOME_PAGE);
        RETURN_PROP_CASE(PR_EMS_AB_X121_ADDRESS);
        RETURN_PROP_CASE(PR_EMS_AB_X25_CALL_USER_DATA_INCOMING);
        RETURN_PROP_CASE(PR_EMS_AB_X25_CALL_USER_DATA_OUTGOING);
        RETURN_PROP_CASE(PR_EMS_AB_X25_FACILITIES_DATA_INCOMING);
        RETURN_PROP_CASE(PR_EMS_AB_X25_FACILITIES_DATA_OUTGOING);
        RETURN_PROP_CASE(PR_EMS_AB_X25_LEASED_LINE_PORT);
        RETURN_PROP_CASE(PR_EMS_AB_X25_LEASED_OR_SWITCHED);
        RETURN_PROP_CASE(PR_EMS_AB_X25_REMOTE_MTA_PHONE);
        RETURN_PROP_CASE(PR_EMS_AB_X400_ATTACHMENT_TYPE);
        RETURN_PROP_CASE(PR_EMS_AB_X400_SELECTOR_SYNTAX);
        RETURN_PROP_CASE(PR_EMS_AB_X500_ACCESS_CONTROL_LIST);
        RETURN_PROP_CASE(PR_EMS_AB_X500_NC);
        RETURN_PROP_CASE(PR_EMS_AB_X500_RDN);
        RETURN_PROP_CASE(PR_EMS_AB_X509_CERT);
        RETURN_PROP_CASE(PR_EMS_AB_XMIT_TIMEOUT_NON_URGENT);
        RETURN_PROP_CASE(PR_EMS_AB_XMIT_TIMEOUT_NORMAL);
        RETURN_PROP_CASE(PR_EMS_AB_XMIT_TIMEOUT_URGENT);
        //End <EMSAbTag.h>

        //<MSPST.h>
        RETURN_PROP_CASE(PR_PST_PATH);
        RETURN_PROP_CASE(PR_PST_REMEMBER_PW);
        //RETURN_PROP_CASE(PR_PST_ENCRYPTION);
        RETURN_PROP_CASE(PR_PST_PW_SZ_OLD);
        RETURN_PROP_CASE(PR_PST_PW_SZ_NEW);
        //End <MSPST.h>

        //CDO props (listed as constants in CDO, but not in MAPI headers
        //Note: commented out props are in MAPI headers under other names
        //		RETURN_PROP_CASE(PR_ATTACH_DATA_BIN);
        //		RETURN_PROP_CASE(PR_BEEPER_TELEPHONE_NUMBER);
        //		RETURN_PROP_CASE(PR_BUSINESS_ADDRESS_CITY);
        //		RETURN_PROP_CASE(PR_BUSINESS_ADDRESS_COUNTRY);
        //		RETURN_PROP_CASE(PR_BUSINESS_ADDRESS_POST_OFFICE_BOX);
        //		RETURN_PROP_CASE(PR_BUSINESS_ADDRESS_POSTAL_CODE);
        //		RETURN_PROP_CASE(PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE);
        //		RETURN_PROP_CASE(PR_BUSINESS_ADDRESS_STREET);
        //		RETURN_PROP_CASE(PR_CELLULAR_TELEPHONE_NUMBER);
        RETURN_PROP_CASE(PR_INTERNET_APPROVED);
        RETURN_PROP_CASE(PR_INTERNET_CONTROL);
        RETURN_PROP_CASE(PR_INTERNET_DISTRIBUTION);
        RETURN_PROP_CASE(PR_INTERNET_FOLLOWUP_TO);
        RETURN_PROP_CASE(PR_INTERNET_LINES);
        RETURN_PROP_CASE(PR_INTERNET_NEWSGROUPS);
        RETURN_PROP_CASE(PR_INTERNET_NNTP_PATH);
        RETURN_PROP_CASE(PR_INTERNET_ORGANIZATION);
        RETURN_PROP_CASE(PR_INTERNET_PRECEDENCE);
        RETURN_PROP_CASE(PR_INTERNET_REFERENCES);
        RETURN_PROP_CASE(PR_NEWSGROUP_NAME);
        RETURN_PROP_CASE(PR_NNTP_XREF);
        //		RETURN_PROP_CASE(PR_OFFICE_TELEPHONE_NUMBER);
        //		RETURN_PROP_CASE(PR_OFFICE2_TELEPHONE_NUMBER);
        RETURN_PROP_CASE(PR_POST_FOLDER_ENTRIES);
        RETURN_PROP_CASE(PR_POST_FOLDER_NAMES);
        RETURN_PROP_CASE(PR_POST_REPLY_DENIED);
        RETURN_PROP_CASE(PR_POST_REPLY_FOLDER_ENTRIES);
        RETURN_PROP_CASE(PR_POST_REPLY_FOLDER_NAMES);
        //		RETURN_PROP_CASE(PR_REFERRED_BY_NAME);//this is PR_PREFERRED_BY_NAME - typo in CDO?
        RETURN_PROP_CASE(PR_SUPERSEDES);

        //End CDO props

        //Properties I've defined because they're missing from the headers.
        RETURN_PROP_CASE(PR_USER_X509_CERTIFICATE);
        RETURN_PROP_CASE(PR_ADMIN_SECURITY_DESCRIPTOR);
        RETURN_PROP_CASE(PR_NT_SECURITY_DESCRIPTOR);
        RETURN_PROP_CASE(PR_BODY_HTML);
        RETURN_PROP_CASE(PR_MSG_EDITOR_FORMAT);
        RETURN_PROP_CASE(PR_INTERNET_MESSAGE_ID);
        RETURN_PROP_CASE(PR_SMTP_ADDRESS);
        RETURN_PROP_CASE(PR_DEF_POST_MSGCLASS);
        RETURN_PROP_CASE(PR_DEF_POST_DISPLAYNAME);
        RETURN_PROP_CASE(PR_INTERNET_ARTICLE_NUMBER);
        RETURN_PROP_CASE(PR_FREEBUSY_ENTRYIDS);
        RETURN_PROP_CASE(PR_INTERNET_CONTENT);

        RETURN_PROP_CASE(PR_IPM_APPOINTMENT_ENTRYID);
        RETURN_PROP_CASE(PR_IPM_CONTACT_ENTRYID);
        RETURN_PROP_CASE(PR_IPM_JOURNAL_ENTRYID);
        RETURN_PROP_CASE(PR_IPM_NOTE_ENTRYID);
        RETURN_PROP_CASE(PR_IPM_TASK_ENTRYID);
        RETURN_PROP_CASE(PR_REM_ONLINE_ENTRYID);
        RETURN_PROP_CASE(PR_REM_OFFLINE_ENTRYID);
        RETURN_PROP_CASE(PR_IPM_DRAFTS_ENTRYID);

        RETURN_PROP_CASE(PR_SEND_INTERNET_ENCODING);
        RETURN_PROP_CASE(PR_RECIPIENT_TRACKSTATUS);
        RETURN_PROP_CASE(PR_RECIPIENT_FLAGS);
        RETURN_PROP_CASE(PR_RECIPIENT_ENTRYID);
        RETURN_PROP_CASE(PR_RECIPIENT_DISPLAY_NAME);
        RETURN_PROP_CASE(PR_ICON_INDEX);
        RETURN_PROP_CASE(PR_ATTR_HIDDEN);
        RETURN_PROP_CASE(PR_ATTR_SYSTEM);
        RETURN_PROP_CASE(PR_ATTR_READONLY);
        RETURN_PROP_CASE(PR_URL_NAME);
        RETURN_PROP_CASE(PR_LOCAL_COMMIT_TIME);
        RETURN_PROP_CASE(PR_LOCAL_COMMIT_TIME_MAX);
        RETURN_PROP_CASE(PR_DELETED_COUNT_TOTAL);
        RETURN_PROP_CASE(PR_ICS_CHANGE_KEY);
        RETURN_PROP_CASE(PR_CREATOR_SID);
        RETURN_PROP_CASE(PR_LAST_MODIFIER_SID);
        RETURN_PROP_CASE(PR_OST_OSTID);
        RETURN_PROP_CASE(PR_OFFLINE_FOLDER);
        RETURN_PROP_CASE(PR_FAV_PARENT_SOURCE_KEY);
        RETURN_PROP_CASE(PR_TRUST_SENDER);
        RETURN_PROP_CASE(PR_URL_COMP_NAME);
        RETURN_PROP_CASE(PR_DOTSTUFF_STATE);
        RETURN_PROP_CASE(PR_IN_REPLY_TO_ID);
        RETURN_PROP_CASE(PR_MAX_CACHED_VIEWS);
        */

        default: return QString("Unknown");
    }
}

static QString entryid( ULONG sz, LPENTRYID eid )
{
    QString s;
    LPBYTE foo;

    s += QString("cb: %1 lpb: ").arg(sz);
    foo = (LPBYTE)eid;
    for ( int i = 0; i < sz; i++ ) {
        s += QString().sprintf("%02x", (*foo));
        foo++;
    }
    
    return s;
}

QString guid( void *data )
{
    QString guid;
    LPBYTE foo = (LPBYTE)data;
    for ( int i = 0; i < sizeof(GUID); i++ ) {
        guid += QString().sprintf("%02x", (*foo));
        foo++;
    }
    return guid;
}

#undef DEFINE_GUID
#undef DEFINE_OLEGUID
#define DEFINE_GUID(name, l, w1, w2, b1, b2, b3, b4, b5, b6, b7, b8) \
        const GUID name = { l, w1, w2, { b1, b2,  b3,  b4,  b5,  b6,  b7,  b8 } }
#define DEFINE_OLEGUID(name, l, w1, w2) DEFINE_GUID(name, l, w1, w2, 0xC0,0,0,0,0,0,0,0x46)
DEFINE_OLEGUID(PS_MAPI, 0x00020328, 0, 0);
DEFINE_OLEGUID(PS_PUBLIC_STRINGS,   0x00020329, 0, 0);

QString HrGetPropertyName(
        LPMESSAGE lpMsg, ULONG tag)
{
    QString ret;

    HRESULT hr;
    SizedSPropTagArray(1,Tags) = {1, {0}};
    LPSPropTagArray lpTags;
    ULONG ulSz;
    LPMAPINAMEID FAR *lppNames = 0;
    static QString ps_mapi;
    static QString ps_public_strings;
    static QString ps_outlook;
    
    Tags.aulPropTag[0] = tag;
    lpTags = (LPSPropTagArray)&Tags;

    hr = lpMsg->GetNamesFromIDs( &lpTags, 0, 0, &ulSz, &lppNames );
    CLEANUP(( FAILED(hr) || !lppNames ), "Can't get custom properties");
    CLEANUP(( ulSz == 0 ), "No custom properties");

    if ( lppNames[0]->ulKind == MNID_STRING ) {
        ret = QString::fromUtf16(lppNames[0]->Kind.lpwstrName);
    } else {
        if ( ps_mapi.isEmpty() ) {
            ps_mapi = guid((LPGUID)&PS_MAPI);
            ps_public_strings = guid((LPGUID)&PS_PUBLIC_STRINGS);
            ps_outlook = guid((LPGUID)&OUTLOOK_GUID);
        }
        QString g = guid(lppNames[0]->lpguid);
        if ( g == ps_mapi )
            g = "PS_MAPI";
        else if ( g == ps_public_strings )
            g = "PS_PUBLIC_STRINGS";
        else if ( g == ps_outlook )
            g = "OUTLOOK_GUID";
        ret = QString("GUID: %1 ID: %2").arg(g).arg(lppNames[0]->Kind.lID);
    }

cleanup:
    if ( lppNames ) MAPIFreeBuffer( lppNames );

    return ret;
}

