/****************************************************************************
**
** This file is part of the Qt Extended Opensource Package.
**
** Copyright (C) 2009 Trolltech ASA.
**
** Contact: Qt Extended Information (info@qtextended.org)
**
** This file may be used under the terms of the GNU General Public License
** version 2.0 as published by the Free Software Foundation and appearing
** in the file LICENSE.GPL included in the packaging of this file.
**
** Please review the following information to ensure GNU General Public
** Licensing requirements will be met:
**     http://www.fsf.org/licensing/licenses/info/GPLv2.html.
**
**
****************************************************************************/

#ifndef SINCTABLE_H
#define SINCTABLE_H

#define MAX_WEIGHT 512
#define MAX_FILTER_VALUE 8192



qint16 sincTable[512][16] = {
 {   0,   0,   0,   0,   0,   0,   0, 8191,   0,   0,   0,   0,   0,   0,   0,   0 },
 {   0,   0,   0,   1,  -3,   6, -15, 8191,  15,  -6,   3,  -1,   0,   0,   0,   0 },
 {   0,   0,  -1,   3,  -7,  13, -30, 8191,  30, -13,   7,  -3,   1,   0,   0,   0 },
 {   0,   1,  -2,   5, -10,  20, -45, 8191,  46, -20,  10,  -5,   2,  -1,   0,   0 },
 {   0,   1,  -3,   7, -14,  26, -60, 8191,  61, -27,  14,  -7,   3,  -1,   0,   0 },
 {   0,   2,  -4,   9, -17,  33, -75, 8190,  77, -33,  18,  -9,   4,  -2,   0,   0 },
 {   0,   2,  -5,  11, -21,  40, -90, 8190,  93, -40,  21, -11,   5,  -2,   0,   0 },
 {  -1,   3,  -6,  13, -24,  46, -105, 8189, 108, -47,  25, -13,   6,  -3,   1,   0 },
 {  -1,   3,  -7,  15, -28,  53, -120, 8188, 124, -54,  28, -15,   7,  -3,   1,   0 },
 {  -1,   3,  -8,  17, -31,  59, -135, 8187, 140, -61,  32, -17,   8,  -3,   1,   0 },
 {  -1,   4,  -9,  19, -35,  66, -149, 8186, 156, -68,  36, -19,   9,  -4,   1,   0 },
 {  -1,   4, -10,  20, -38,  72, -164, 8185, 172, -75,  39, -21,  10,  -4,   1,   0 },
 {  -1,   5, -11,  22, -42,  79, -179, 8184, 188, -81,  43, -23,  11,  -5,   1,   0 },
 {  -1,   5, -12,  24, -45,  85, -193, 8183, 204, -88,  47, -25,  12,  -5,   2,   0 },
 {  -2,   5, -13,  26, -49,  92, -208, 8181, 220, -95,  50, -27,  13,  -6,   2,   0 },
 {  -2,   6, -14,  28, -52,  98, -222, 8180, 237, -102,  54, -29,  14,  -6,   2,   0 },
 {  -2,   6, -15,  30, -56, 105, -236, 8178, 253, -109,  58, -31,  15,  -7,   2,   0 },
 {  -2,   7, -16,  32, -59, 111, -251, 8176, 269, -116,  62, -33,  17,  -7,   2,   0 },
 {  -2,   7, -17,  33, -62, 117, -265, 8174, 286, -123,  65, -35,  18,  -8,   2,   0 },
 {  -2,   7, -18,  35, -66, 124, -279, 8172, 302, -130,  69, -37,  19,  -8,   3,   0 },
 {  -2,   8, -18,  37, -69, 130, -293, 8170, 319, -137,  73, -39,  20,  -9,   3,   0 },
 {  -3,   8, -19,  39, -73, 137, -307, 8168, 335, -144,  76, -41,  21,  -9,   3,   0 },
 {  -3,   9, -20,  41, -76, 143, -321, 8166, 352, -151,  80, -43,  22,  -9,   3,   0 },
 {  -3,   9, -21,  43, -79, 149, -334, 8164, 369, -158,  84, -45,  23, -10,   3,   0 },
 {  -3,  10, -22,  44, -83, 155, -348, 8161, 386, -166,  88, -47,  24, -10,   3,   0 },
 {  -3,  10, -23,  46, -86, 162, -362, 8159, 402, -173,  91, -49,  25, -11,   4,   0 },
 {  -3,  10, -24,  48, -89, 168, -375, 8156, 419, -180,  95, -51,  26, -11,   4,   0 },
 {  -3,  11, -25,  50, -93, 174, -389, 8153, 436, -187,  99, -53,  27, -12,   4,   0 },
 {  -3,  11, -26,  51, -96, 180, -402, 8150, 453, -194, 103, -55,  28, -12,   4,   0 },
 {  -4,  11, -27,  53, -99, 186, -416, 8147, 470, -201, 106, -57,  29, -13,   4,   0 },
 {  -4,  12, -27,  55, -103, 192, -429, 8144, 488, -208, 110, -59,  30, -13,   4,  -1 },
 {  -4,  12, -28,  57, -106, 198, -442, 8141, 505, -215, 114, -61,  31, -14,   5,  -1 },
 {  -4,  13, -29,  59, -109, 205, -456, 8138, 522, -223, 118, -63,  32, -14,   5,  -1 },
 {  -4,  13, -30,  60, -112, 211, -469, 8134, 539, -230, 122, -65,  33, -15,   5,  -1 },
 {  -4,  13, -31,  62, -116, 217, -482, 8131, 557, -237, 125, -68,  34, -15,   5,  -1 },
 {  -4,  14, -32,  64, -119, 223, -495, 8127, 574, -244, 129, -70,  35, -16,   5,  -1 },
 {  -5,  14, -33,  65, -122, 229, -508, 8123, 592, -251, 133, -72,  36, -16,   5,  -1 },
 {  -5,  14, -34,  67, -125, 235, -521, 8120, 609, -259, 137, -74,  37, -17,   6,  -1 },
 {  -5,  15, -34,  69, -128, 240, -533, 8116, 627, -266, 141, -76,  38, -17,   6,  -1 },
 {  -5,  15, -35,  71, -132, 246, -546, 8112, 644, -273, 144, -78,  39, -18,   6,  -1 },
 {  -5,  16, -36,  72, -135, 252, -559, 8107, 662, -280, 148, -80,  41, -18,   6,  -1 },
 {  -5,  16, -37,  74, -138, 258, -571, 8103, 680, -288, 152, -82,  42, -19,   6,  -1 },
 {  -5,  16, -38,  76, -141, 264, -584, 8099, 698, -295, 156, -84,  43, -19,   7,  -1 },
 {  -5,  17, -39,  77, -144, 270, -596, 8094, 716, -302, 160, -86,  44, -19,   7,  -1 },
 {  -5,  17, -39,  79, -147, 275, -608, 8090, 734, -309, 164, -88,  45, -20,   7,  -1 },
 {  -6,  17, -40,  81, -150, 281, -621, 8085, 752, -317, 167, -90,  46, -20,   7,  -1 },
 {  -6,  18, -41,  82, -153, 287, -633, 8080, 770, -324, 171, -92,  47, -21,   7,  -1 },
 {  -6,  18, -42,  84, -157, 293, -645, 8076, 788, -331, 175, -94,  48, -21,   7,  -1 },
 {  -6,  18, -43,  86, -160, 298, -657, 8071, 806, -339, 179, -96,  49, -22,   8,  -1 },
 {  -6,  19, -44,  87, -163, 304, -669, 8065, 824, -346, 183, -99,  50, -22,   8,  -1 },
 {  -6,  19, -44,  89, -166, 310, -681, 8060, 842, -353, 187, -101,  51, -23,   8,  -1 },
 {  -6,  19, -45,  90, -169, 315, -693, 8055, 861, -361, 190, -103,  52, -23,   8,  -1 },
 {  -6,  20, -46,  92, -172, 321, -704, 8050, 879, -368, 194, -105,  53, -24,   8,  -1 },
 {  -7,  20, -47,  94, -175, 326, -716, 8044, 897, -375, 198, -107,  54, -24,   9,  -1 },
 {  -7,  21, -47,  95, -178, 332, -728, 8039, 916, -383, 202, -109,  55, -25,   9,  -1 },
 {  -7,  21, -48,  97, -181, 337, -739, 8033, 934, -390, 206, -111,  57, -25,   9,  -2 },
 {  -7,  21, -49,  98, -184, 343, -751, 8027, 953, -397, 210, -113,  58, -26,   9,  -2 },
 {  -7,  22, -50, 100, -186, 348, -762, 8021, 971, -405, 214, -115,  59, -26,   9,  -2 },
 {  -7,  22, -51, 102, -189, 354, -773, 8015, 990, -412, 217, -117,  60, -27,   9,  -2 },
 {  -7,  22, -51, 103, -192, 359, -785, 8009, 1009, -420, 221, -119,  61, -27,  10,  -2 },
 {  -7,  22, -52, 105, -195, 364, -796, 8003, 1028, -427, 225, -122,  62, -28,  10,  -2 },
 {  -7,  23, -53, 106, -198, 370, -807, 7997, 1046, -434, 229, -124,  63, -28,  10,  -2 },
 {  -7,  23, -54, 108, -201, 375, -818, 7990, 1065, -442, 233, -126,  64, -29,  10,  -2 },
 {  -8,  23, -54, 109, -204, 380, -829, 7984, 1084, -449, 237, -128,  65, -29,  10,  -2 },
 {  -8,  24, -55, 111, -207, 385, -840, 7977, 1103, -457, 241, -130,  66, -30,  11,  -2 },
 {  -8,  24, -56, 112, -209, 391, -850, 7971, 1122, -464, 244, -132,  67, -30,  11,  -2 },
 {  -8,  24, -57, 114, -212, 396, -861, 7964, 1141, -471, 248, -134,  68, -31,  11,  -2 },
 {  -8,  25, -57, 115, -215, 401, -872, 7957, 1160, -479, 252, -136,  70, -31,  11,  -2 },
 {  -8,  25, -58, 117, -218, 406, -882, 7950, 1179, -486, 256, -138,  71, -32,  11,  -2 },
 {  -8,  25, -59, 118, -221, 411, -893, 7943, 1199, -494, 260, -140,  72, -32,  12,  -2 },
 {  -8,  26, -60, 120, -223, 416, -903, 7936, 1218, -501, 264, -142,  73, -33,  12,  -2 },
 {  -8,  26, -60, 121, -226, 421, -914, 7928, 1237, -508, 268, -145,  74, -33,  12,  -2 },
 {  -8,  26, -61, 122, -229, 426, -924, 7921, 1256, -516, 271, -147,  75, -34,  12,  -2 },
 {  -9,  27, -62, 124, -231, 431, -934, 7913, 1276, -523, 275, -149,  76, -34,  12,  -2 },
 {  -9,  27, -62, 125, -234, 436, -944, 7906, 1295, -531, 279, -151,  77, -35,  13,  -2 },
 {  -9,  27, -63, 127, -237, 441, -954, 7898, 1315, -538, 283, -153,  78, -35,  13,  -2 },
 {  -9,  27, -64, 128, -239, 446, -964, 7890, 1334, -545, 287, -155,  79, -36,  13,  -3 },
 {  -9,  28, -64, 130, -242, 451, -974, 7883, 1354, -553, 291, -157,  80, -36,  13,  -3 },
 {  -9,  28, -65, 131, -245, 456, -984, 7875, 1373, -560, 294, -159,  81, -37,  13,  -3 },
 {  -9,  28, -66, 132, -247, 460, -994, 7866, 1393, -568, 298, -161,  83, -37,  14,  -3 },
 {  -9,  29, -66, 134, -250, 465, -1003, 7858, 1413, -575, 302, -163,  84, -38,  14,  -3 },
 {  -9,  29, -67, 135, -252, 470, -1013, 7850, 1432, -582, 306, -165,  85, -38,  14,  -3 },
 {  -9,  29, -68, 136, -255, 475, -1022, 7842, 1452, -590, 310, -168,  86, -39,  14,  -3 },
 {  -9,  29, -68, 138, -257, 479, -1032, 7833, 1472, -597, 314, -170,  87, -39,  14,  -3 },
 { -10,  30, -69, 139, -260, 484, -1041, 7825, 1492, -604, 317, -172,  88, -40,  15,  -3 },
 { -10,  30, -70, 140, -262, 489, -1050, 7816, 1511, -612, 321, -174,  89, -41,  15,  -3 },
 { -10,  30, -70, 142, -265, 493, -1060, 7807, 1531, -619, 325, -176,  90, -41,  15,  -3 },
 { -10,  30, -71, 143, -267, 498, -1069, 7798, 1551, -627, 329, -178,  91, -42,  15,  -3 },
 { -10,  31, -72, 144, -270, 502, -1078, 7789, 1571, -634, 333, -180,  92, -42,  15,  -3 },
 { -10,  31, -72, 146, -272, 507, -1087, 7780, 1591, -641, 337, -182,  93, -43,  15,  -3 },
 { -10,  31, -73, 147, -275, 511, -1096, 7771, 1611, -649, 340, -184,  94, -43,  16,  -3 },
 { -10,  31, -74, 148, -277, 516, -1105, 7762, 1632, -656, 344, -186,  96, -44,  16,  -3 },
 { -10,  32, -74, 150, -280, 520, -1113, 7753, 1652, -663, 348, -188,  97, -44,  16,  -3 },
 { -10,  32, -75, 151, -282, 524, -1122, 7743, 1672, -671, 352, -190,  98, -45,  16,  -3 },
 { -10,  32, -75, 152, -284, 529, -1131, 7734, 1692, -678, 356, -192,  99, -45,  16,  -3 },
 { -10,  32, -76, 153, -287, 533, -1139, 7724, 1712, -686, 359, -194, 100, -46,  17,  -3 },
 { -10,  33, -77, 154, -289, 537, -1148, 7714, 1733, -693, 363, -196, 101, -46,  17,  -4 },
 { -11,  33, -77, 156, -291, 542, -1156, 7705, 1753, -700, 367, -198, 102, -47,  17,  -4 },
 { -11,  33, -78, 157, -294, 546, -1164, 7695, 1773, -707, 371, -201, 103, -47,  17,  -4 },
 { -11,  33, -78, 158, -296, 550, -1173, 7685, 1794, -715, 374, -203, 104, -48,  17,  -4 },
 { -11,  34, -79, 159, -298, 554, -1181, 7675, 1814, -722, 378, -205, 105, -48,  18,  -4 },
 { -11,  34, -79, 161, -300, 558, -1189, 7664, 1835, -729, 382, -207, 106, -49,  18,  -4 },
 { -11,  34, -80, 162, -303, 562, -1197, 7654, 1855, -737, 386, -209, 107, -49,  18,  -4 },
 { -11,  34, -81, 163, -305, 566, -1205, 7644, 1876, -744, 389, -211, 108, -50,  18,  -4 },
 { -11,  35, -81, 164, -307, 570, -1213, 7633, 1896, -751, 393, -213, 109, -50,  18,  -4 },
 { -11,  35, -82, 165, -309, 574, -1221, 7623, 1917, -758, 397, -215, 110, -51,  19,  -4 },
 { -11,  35, -82, 166, -311, 578, -1228, 7612, 1938, -766, 401, -217, 112, -51,  19,  -4 },
 { -11,  35, -83, 167, -313, 582, -1236, 7601, 1958, -773, 404, -219, 113, -52,  19,  -4 },
 { -11,  35, -83, 169, -315, 586, -1243, 7591, 1979, -780, 408, -221, 114, -52,  19,  -4 },
 { -11,  36, -84, 170, -318, 590, -1251, 7580, 2000, -787, 412, -223, 115, -53,  19,  -4 },
 { -11,  36, -84, 171, -320, 594, -1258, 7569, 2021, -795, 415, -225, 116, -53,  20,  -4 },
 { -11,  36, -85, 172, -322, 598, -1266, 7558, 2041, -802, 419, -227, 117, -54,  20,  -4 },
 { -11,  36, -85, 173, -324, 601, -1273, 7546, 2062, -809, 423, -229, 118, -54,  20,  -4 },
 { -12,  37, -86, 174, -326, 605, -1280, 7535, 2083, -816, 426, -231, 119, -55,  20,  -4 },
 { -12,  37, -86, 175, -328, 609, -1287, 7524, 2104, -823, 430, -233, 120, -55,  20,  -4 },
 { -12,  37, -87, 176, -330, 612, -1294, 7512, 2125, -831, 434, -235, 121, -56,  21,  -5 },
 { -12,  37, -87, 177, -332, 616, -1301, 7501, 2146, -838, 437, -237, 122, -56,  21,  -5 },
 { -12,  37, -88, 178, -334, 620, -1308, 7489, 2167, -845, 441, -239, 123, -57,  21,  -5 },
 { -12,  38, -88, 179, -336, 623, -1315, 7477, 2188, -852, 445, -241, 124, -57,  21,  -5 },
 { -12,  38, -89, 180, -338, 627, -1322, 7465, 2209, -859, 448, -243, 125, -58,  21,  -5 },
 { -12,  38, -89, 181, -340, 630, -1328, 7454, 2230, -866, 452, -245, 126, -58,  22,  -5 },
 { -12,  38, -90, 182, -341, 634, -1335, 7442, 2251, -873, 455, -247, 127, -59,  22,  -5 },
 { -12,  38, -90, 183, -343, 637, -1341, 7430, 2272, -880, 459, -249, 128, -59,  22,  -5 },
 { -12,  38, -91, 184, -345, 640, -1348, 7417, 2293, -887, 463, -251, 129, -60,  22,  -5 },
 { -12,  39, -91, 185, -347, 644, -1354, 7405, 2314, -894, 466, -252, 130, -60,  22,  -5 },
 { -12,  39, -92, 186, -349, 647, -1360, 7393, 2336, -901, 470, -254, 131, -61,  23,  -5 },
 { -12,  39, -92, 187, -351, 650, -1367, 7380, 2357, -908, 473, -256, 132, -61,  23,  -5 },
 { -12,  39, -93, 188, -352, 654, -1373, 7368, 2378, -915, 477, -258, 133, -62,  23,  -5 },
 { -12,  39, -93, 189, -354, 657, -1379, 7355, 2399, -922, 480, -260, 134, -62,  23,  -5 },
 { -12,  40, -93, 190, -356, 660, -1385, 7343, 2421, -929, 484, -262, 135, -63,  23,  -5 },
 { -12,  40, -94, 191, -358, 663, -1391, 7330, 2442, -936, 487, -264, 136, -63,  24,  -5 },
 { -12,  40, -94, 192, -359, 666, -1396, 7317, 2463, -943, 491, -266, 137, -63,  24,  -5 },
 { -12,  40, -95, 192, -361, 669, -1402, 7304, 2485, -950, 494, -268, 138, -64,  24,  -6 },
 { -13,  40, -95, 193, -363, 672, -1408, 7291, 2506, -957, 498, -270, 139, -64,  24,  -6 },
 { -13,  40, -96, 194, -364, 675, -1414, 7278, 2527, -964, 501, -272, 140, -65,  24,  -6 },
 { -13,  40, -96, 195, -366, 678, -1419, 7265, 2549, -971, 505, -273, 141, -65,  25,  -6 },
 { -13,  41, -96, 196, -368, 681, -1424, 7251, 2570, -978, 508, -275, 142, -66,  25,  -6 },
 { -13,  41, -97, 197, -369, 684, -1430, 7238, 2592, -984, 512, -277, 143, -66,  25,  -6 },
 { -13,  41, -97, 198, -371, 687, -1435, 7225, 2613, -991, 515, -279, 144, -67,  25,  -6 },
 { -13,  41, -98, 198, -372, 690, -1440, 7211, 2635, -998, 518, -281, 145, -67,  25,  -6 },
 { -13,  41, -98, 199, -374, 693, -1446, 7197, 2656, -1005, 522, -283, 146, -68,  26,  -6 },
 { -13,  41, -98, 200, -375, 696, -1451, 7184, 2678, -1012, 525, -285, 147, -68,  26,  -6 },
 { -13,  42, -99, 201, -377, 698, -1456, 7170, 2699, -1018, 529, -286, 148, -69,  26,  -6 },
 { -13,  42, -99, 202, -378, 701, -1461, 7156, 2721, -1025, 532, -288, 149, -69,  26,  -6 },
 { -13,  42, -99, 202, -380, 704, -1465, 7142, 2743, -1032, 535, -290, 150, -70,  26,  -6 },
 { -13,  42, -100, 203, -381, 706, -1470, 7128, 2764, -1038, 539, -292, 151, -70,  27,  -6 },
 { -13,  42, -100, 204, -383, 709, -1475, 7114, 2786, -1045, 542, -294, 152, -71,  27,  -6 },
 { -13,  42, -100, 205, -384, 712, -1480, 7100, 2807, -1052, 545, -295, 153, -71,  27,  -6 },
 { -13,  42, -101, 205, -386, 714, -1484, 7086, 2829, -1058, 549, -297, 154, -72,  27,  -6 },
 { -13,  42, -101, 206, -387, 717, -1489, 7071, 2851, -1065, 552, -299, 155, -72,  27,  -6 },
 { -13,  43, -101, 207, -388, 719, -1493, 7057, 2872, -1071, 555, -301, 156, -72,  28,  -7 },
 { -13,  43, -102, 207, -390, 722, -1498, 7043, 2894, -1078, 558, -303, 157, -73,  28,  -7 },
 { -13,  43, -102, 208, -391, 724, -1502, 7028, 2916, -1084, 562, -304, 158, -73,  28,  -7 },
 { -13,  43, -102, 209, -392, 726, -1506, 7013, 2938, -1091, 565, -306, 159, -74,  28,  -7 },
 { -13,  43, -103, 209, -394, 729, -1510, 6999, 2959, -1097, 568, -308, 160, -74,  28,  -7 },
 { -13,  43, -103, 210, -395, 731, -1514, 6984, 2981, -1104, 571, -310, 161, -75,  28,  -7 },
 { -13,  43, -103, 211, -396, 733, -1518, 6969, 3003, -1110, 574, -311, 162, -75,  29,  -7 },
 { -13,  43, -103, 211, -397, 736, -1522, 6954, 3025, -1117, 578, -313, 162, -76,  29,  -7 },
 { -13,  43, -104, 212, -399, 738, -1526, 6939, 3046, -1123, 581, -315, 163, -76,  29,  -7 },
 { -13,  44, -104, 213, -400, 740, -1530, 6924, 3068, -1129, 584, -316, 164, -77,  29,  -7 },
 { -13,  44, -104, 213, -401, 742, -1533, 6909, 3090, -1136, 587, -318, 165, -77,  29,  -7 },
 { -13,  44, -105, 214, -402, 744, -1537, 6893, 3112, -1142, 590, -320, 166, -77,  30,  -7 },
 { -13,  44, -105, 214, -403, 746, -1541, 6878, 3134, -1148, 593, -322, 167, -78,  30,  -7 },
 { -13,  44, -105, 215, -404, 748, -1544, 6863, 3155, -1154, 596, -323, 168, -78,  30,  -7 },
 { -13,  44, -105, 216, -405, 750, -1548, 6847, 3177, -1161, 599, -325, 169, -79,  30,  -7 },
 { -13,  44, -106, 216, -407, 752, -1551, 6832, 3199, -1167, 602, -327, 170, -79,  30,  -7 },
 { -13,  44, -106, 217, -408, 754, -1554, 6816, 3221, -1173, 605, -328, 171, -80,  31,  -7 },
 { -13,  44, -106, 217, -409, 756, -1557, 6800, 3243, -1179, 608, -330, 171, -80,  31,  -8 },
 { -13,  44, -106, 218, -410, 758, -1560, 6785, 3265, -1185, 611, -331, 172, -81,  31,  -8 },
 { -13,  44, -107, 218, -411, 760, -1564, 6769, 3286, -1191, 614, -333, 173, -81,  31,  -8 },
 { -13,  44, -107, 219, -412, 762, -1567, 6753, 3308, -1197, 617, -335, 174, -81,  31,  -8 },
 { -13,  45, -107, 219, -413, 763, -1569, 6737, 3330, -1203, 620, -336, 175, -82,  31,  -8 },
 { -13,  45, -107, 220, -414, 765, -1572, 6721, 3352, -1209, 623, -338, 176, -82,  32,  -8 },
 { -13,  45, -107, 220, -415, 767, -1575, 6705, 3374, -1215, 626, -339, 177, -83,  32,  -8 },
 { -13,  45, -108, 221, -415, 768, -1578, 6688, 3396, -1221, 629, -341, 177, -83,  32,  -8 },
 { -13,  45, -108, 221, -416, 770, -1580, 6672, 3418, -1227, 632, -343, 178, -83,  32,  -8 },
 { -13,  45, -108, 222, -417, 772, -1583, 6656, 3440, -1233, 635, -344, 179, -84,  32,  -8 },
 { -13,  45, -108, 222, -418, 773, -1585, 6639, 3462, -1239, 638, -346, 180, -84,  33,  -8 },
 { -14,  45, -108, 222, -419, 775, -1588, 6623, 3483, -1244, 640, -347, 181, -85,  33,  -8 },
 { -14,  45, -109, 223, -420, 776, -1590, 6606, 3505, -1250, 643, -349, 182, -85,  33,  -8 },
 { -14,  45, -109, 223, -421, 778, -1593, 6590, 3527, -1256, 646, -350, 182, -86,  33,  -8 },
 { -14,  45, -109, 224, -421, 779, -1595, 6573, 3549, -1262, 649, -352, 183, -86,  33,  -8 },
 { -14,  45, -109, 224, -422, 780, -1597, 6556, 3571, -1267, 651, -353, 184, -86,  33,  -8 },
 { -14,  45, -109, 224, -423, 782, -1599, 6540, 3593, -1273, 654, -355, 185, -87,  34,  -8 },
 { -14,  45, -109, 225, -424, 783, -1601, 6523, 3615, -1279, 657, -356, 186, -87,  34,  -8 },
 { -14,  45, -110, 225, -424, 784, -1603, 6506, 3637, -1284, 660, -358, 186, -88,  34,  -9 },
 { -14,  45, -110, 225, -425, 786, -1605, 6489, 3659, -1290, 662, -359, 187, -88,  34,  -9 },
 { -14,  45, -110, 226, -426, 787, -1607, 6472, 3681, -1295, 665, -361, 188, -88,  34,  -9 },
 { -14,  45, -110, 226, -426, 788, -1608, 6454, 3703, -1301, 668, -362, 189, -89,  34,  -9 },
 { -14,  45, -110, 226, -427, 789, -1610, 6437, 3724, -1306, 670, -363, 189, -89,  35,  -9 },
 { -14,  46, -110, 227, -428, 790, -1612, 6420, 3746, -1312, 673, -365, 190, -89,  35,  -9 },
 { -14,  46, -110, 227, -428, 791, -1613, 6403, 3768, -1317, 675, -366, 191, -90,  35,  -9 },
 { -14,  46, -110, 227, -429, 793, -1615, 6385, 3790, -1322, 678, -368, 192, -90,  35,  -9 },
 { -14,  46, -111, 228, -429, 794, -1616, 6368, 3812, -1328, 680, -369, 192, -91,  35,  -9 },
 { -13,  46, -111, 228, -430, 795, -1617, 6350, 3834, -1333, 683, -370, 193, -91,  35,  -9 },
 { -13,  46, -111, 228, -431, 795, -1619, 6333, 3856, -1338, 685, -372, 194, -91,  36,  -9 },
 { -13,  46, -111, 228, -431, 796, -1620, 6315, 3878, -1343, 688, -373, 195, -92,  36,  -9 },
 { -13,  46, -111, 229, -432, 797, -1621, 6297, 3899, -1348, 690, -374, 195, -92,  36,  -9 },
 { -13,  46, -111, 229, -432, 798, -1622, 6280, 3921, -1353, 693, -376, 196, -92,  36,  -9 },
 { -13,  46, -111, 229, -432, 799, -1623, 6262, 3943, -1359, 695, -377, 197, -93,  36,  -9 },
 { -13,  46, -111, 229, -433, 800, -1624, 6244, 3965, -1364, 698, -378, 198, -93,  36,  -9 },
 { -13,  46, -111, 229, -433, 800, -1625, 6226, 3987, -1369, 700, -380, 198, -93,  37,  -9 },
 { -13,  46, -111, 230, -434, 801, -1626, 6208, 4008, -1374, 702, -381, 199, -94,  37,  -9 },
 { -13,  46, -111, 230, -434, 802, -1626, 6190, 4030, -1379, 705, -382, 200, -94,  37, -10 },
 { -13,  46, -111, 230, -434, 803, -1627, 6172, 4052, -1383, 707, -383, 200, -95,  37, -10 },
 { -13,  46, -111, 230, -435, 803, -1628, 6154, 4074, -1388, 709, -385, 201, -95,  37, -10 },
 { -13,  46, -112, 230, -435, 804, -1628, 6135, 4096, -1393, 711, -386, 202, -95,  37, -10 },
 { -13,  46, -112, 230, -435, 804, -1629, 6117, 4117, -1398, 714, -387, 202, -96,  37, -10 },
 { -13,  46, -112, 231, -436, 805, -1629, 6099, 4139, -1403, 716, -388, 203, -96,  38, -10 },
 { -13,  46, -112, 231, -436, 805, -1629, 6080, 4161, -1407, 718, -389, 204, -96,  38, -10 },
 { -13,  46, -112, 231, -436, 806, -1630, 6062, 4183, -1412, 720, -391, 204, -97,  38, -10 },
 { -13,  46, -112, 231, -437, 806, -1630, 6043, 4204, -1417, 722, -392, 205, -97,  38, -10 },
 { -13,  46, -112, 231, -437, 807, -1630, 6025, 4226, -1421, 724, -393, 206, -97,  38, -10 },
 { -13,  46, -112, 231, -437, 807, -1630, 6006, 4248, -1426, 727, -394, 206, -98,  38, -10 },
 { -13,  46, -112, 231, -437, 807, -1630, 5987, 4269, -1430, 729, -395, 207, -98,  38, -10 },
 { -13,  46, -112, 231, -437, 808, -1630, 5969, 4291, -1435, 731, -396, 207, -98,  39, -10 },
 { -13,  46, -112, 231, -438, 808, -1630, 5950, 4313, -1439, 733, -397, 208, -98,  39, -10 },
 { -13,  46, -112, 231, -438, 808, -1630, 5931, 4334, -1443, 735, -398, 209, -99,  39, -10 },
 { -13,  46, -112, 231, -438, 808, -1630, 5912, 4356, -1448, 737, -400, 209, -99,  39, -10 },
 { -13,  46, -112, 231, -438, 808, -1629, 5893, 4377, -1452, 739, -401, 210, -99,  39, -10 },
 { -13,  46, -112, 231, -438, 809, -1629, 5874, 4399, -1456, 741, -402, 210, -100,  39, -10 },
 { -13,  46, -112, 231, -438, 809, -1629, 5855, 4420, -1460, 742, -403, 211, -100,  39, -10 },
 { -13,  46, -112, 231, -438, 809, -1628, 5836, 4442, -1464, 744, -404, 211, -100,  40, -11 },
 { -13,  45, -112, 231, -438, 809, -1628, 5817, 4463, -1469, 746, -405, 212, -101,  40, -11 },
 { -13,  45, -112, 231, -438, 809, -1627, 5798, 4485, -1473, 748, -406, 213, -101,  40, -11 },
 { -13,  45, -112, 231, -438, 809, -1626, 5778, 4506, -1477, 750, -407, 213, -101,  40, -11 },
 { -13,  45, -112, 231, -438, 809, -1626, 5759, 4528, -1481, 752, -408, 214, -101,  40, -11 },
 { -13,  45, -111, 231, -438, 809, -1625, 5740, 4549, -1485, 753, -409, 214, -102,  40, -11 },
 { -13,  45, -111, 231, -438, 809, -1624, 5720, 4571, -1488, 755, -410, 215, -102,  40, -11 },
 { -13,  45, -111, 231, -438, 808, -1623, 5701, 4592, -1492, 757, -410, 215, -102,  41, -11 },
 { -13,  45, -111, 231, -438, 808, -1622, 5681, 4613, -1496, 759, -411, 216, -103,  41, -11 },
 { -13,  45, -111, 231, -438, 808, -1621, 5662, 4635, -1500, 760, -412, 216, -103,  41, -11 },
 { -13,  45, -111, 231, -438, 808, -1620, 5642, 4656, -1503, 762, -413, 217, -103,  41, -11 },
 { -13,  45, -111, 231, -438, 808, -1619, 5623, 4677, -1507, 763, -414, 217, -103,  41, -11 },
 { -13,  45, -111, 231, -437, 807, -1618, 5603, 4699, -1511, 765, -415, 218, -104,  41, -11 },
 { -13,  45, -111, 231, -437, 807, -1617, 5583, 4720, -1514, 767, -416, 218, -104,  41, -11 },
 { -13,  45, -111, 231, -437, 807, -1615, 5563, 4741, -1518, 768, -417, 219, -104,  41, -11 },
 { -13,  45, -111, 230, -437, 806, -1614, 5544, 4762, -1521, 770, -417, 219, -104,  41, -11 },
 { -13,  45, -111, 230, -437, 806, -1613, 5524, 4783, -1525, 771, -418, 219, -105,  42, -11 },
 { -13,  45, -111, 230, -436, 805, -1611, 5504, 4804, -1528, 772, -419, 220, -105,  42, -11 },
 { -13,  45, -110, 230, -436, 805, -1610, 5484, 4826, -1531, 774, -420, 220, -105,  42, -11 },
 { -13,  45, -110, 230, -436, 804, -1608, 5464, 4847, -1534, 775, -420, 221, -105,  42, -11 },
 { -13,  45, -110, 230, -436, 804, -1606, 5444, 4868, -1538, 777, -421, 221, -105,  42, -11 },
 { -13,  44, -110, 229, -435, 803, -1605, 5424, 4889, -1541, 778, -422, 222, -106,  42, -12 },
 { -12,  44, -110, 229, -435, 803, -1603, 5404, 4910, -1544, 779, -423, 222, -106,  42, -12 },
 { -12,  44, -110, 229, -435, 802, -1601, 5383, 4931, -1547, 781, -423, 222, -106,  42, -12 },
 { -12,  44, -110, 229, -434, 801, -1599, 5363, 4952, -1550, 782, -424, 223, -106,  42, -12 },
 { -12,  44, -110, 229, -434, 801, -1597, 5343, 4972, -1553, 783, -425, 223, -107,  43, -12 },
 { -12,  44, -109, 228, -434, 800, -1595, 5323, 4993, -1556, 784, -425, 223, -107,  43, -12 },
 { -12,  44, -109, 228, -433, 799, -1593, 5302, 5014, -1559, 785, -426, 224, -107,  43, -12 },
 { -12,  44, -109, 228, -433, 798, -1591, 5282, 5035, -1561, 787, -427, 224, -107,  43, -12 },
 { -12,  44, -109, 228, -432, 798, -1589, 5262, 5056, -1564, 788, -427, 225, -107,  43, -12 },
 { -12,  44, -109, 227, -432, 797, -1587, 5241, 5076, -1567, 789, -428, 225, -107,  43, -12 },
 { -12,  44, -109, 227, -431, 796, -1584, 5221, 5097, -1570, 790, -428, 225, -108,  43, -12 },
 { -12,  44, -109, 227, -431, 795, -1582, 5200, 5118, -1572, 791, -429, 226, -108,  43, -12 },
 { -12,  44, -108, 226, -430, 794, -1580, 5180, 5139, -1575, 792, -429, 226, -108,  43, -12 },
 { -12,  43, -108, 226, -430, 793, -1577, 5159, 5159, -1577, 793, -430, 226, -108,  43, -12 },
 { -12,  43, -108, 226, -429, 792, -1575, 5139, 5180, -1580, 794, -430, 226, -108,  44, -12 },
 { -12,  43, -108, 226, -429, 791, -1572, 5118, 5200, -1582, 795, -431, 227, -109,  44, -12 },
 { -12,  43, -108, 225, -428, 790, -1570, 5097, 5221, -1584, 796, -431, 227, -109,  44, -12 },
 { -12,  43, -108, 225, -428, 789, -1567, 5077, 5241, -1587, 797, -432, 227, -109,  44, -12 },
 { -12,  43, -107, 225, -427, 788, -1564, 5056, 5262, -1589, 797, -432, 228, -109,  44, -12 },
 { -12,  43, -107, 224, -427, 787, -1562, 5035, 5282, -1591, 798, -433, 228, -109,  44, -12 },
 { -12,  43, -107, 224, -426, 786, -1559, 5014, 5302, -1593, 799, -433, 228, -109,  44, -12 },
 { -12,  43, -107, 224, -425, 784, -1556, 4993, 5323, -1595, 800, -434, 228, -109,  44, -12 },
 { -12,  43, -107, 223, -425, 783, -1553, 4973, 5343, -1597, 800, -434, 229, -110,  44, -12 },
 { -12,  42, -106, 223, -424, 782, -1550, 4952, 5363, -1599, 801, -434, 229, -110,  44, -12 },
 { -12,  42, -106, 222, -423, 781, -1547, 4931, 5383, -1601, 802, -435, 229, -110,  44, -12 },
 { -12,  42, -106, 222, -423, 779, -1544, 4910, 5404, -1603, 802, -435, 229, -110,  44, -12 },
 { -12,  42, -106, 222, -422, 778, -1541, 4889, 5424, -1604, 803, -435, 229, -110,  44, -12 },
 { -11,  42, -105, 221, -421, 777, -1538, 4868, 5444, -1606, 804, -436, 230, -110,  45, -13 },
 { -11,  42, -105, 221, -420, 775, -1535, 4847, 5464, -1608, 804, -436, 230, -110,  45, -13 },
 { -11,  42, -105, 220, -420, 774, -1531, 4826, 5484, -1609, 805, -436, 230, -110,  45, -13 },
 { -11,  42, -105, 220, -419, 773, -1528, 4805, 5504, -1611, 805, -436, 230, -111,  45, -13 },
 { -11,  42, -105, 220, -418, 771, -1525, 4783, 5524, -1612, 806, -437, 230, -111,  45, -13 },
 { -11,  41, -104, 219, -417, 770, -1521, 4762, 5543, -1614, 806, -437, 230, -111,  45, -13 },
 { -11,  41, -104, 219, -417, 768, -1518, 4741, 5563, -1615, 806, -437, 230, -111,  45, -13 },
 { -11,  41, -104, 218, -416, 767, -1514, 4720, 5583, -1617, 807, -437, 231, -111,  45, -13 },
 { -11,  41, -104, 218, -415, 765, -1511, 4699, 5603, -1618, 807, -437, 231, -111,  45, -13 },
 { -11,  41, -103, 217, -414, 763, -1507, 4677, 5622, -1619, 807, -438, 231, -111,  45, -13 },
 { -11,  41, -103, 217, -413, 762, -1503, 4656, 5642, -1620, 808, -438, 231, -111,  45, -13 },
 { -11,  41, -103, 216, -412, 760, -1500, 4635, 5662, -1621, 808, -438, 231, -111,  45, -13 },
 { -11,  41, -103, 216, -411, 759, -1496, 4613, 5681, -1622, 808, -438, 231, -111,  45, -13 },
 { -11,  41, -102, 215, -410, 757, -1492, 4592, 5701, -1623, 808, -438, 231, -111,  45, -13 },
 { -11,  40, -102, 215, -410, 755, -1488, 4571, 5720, -1624, 808, -438, 231, -111,  45, -13 },
 { -11,  40, -102, 214, -409, 753, -1485, 4549, 5740, -1625, 809, -438, 231, -111,  45, -13 },
 { -11,  40, -101, 214, -408, 752, -1481, 4528, 5759, -1626, 809, -438, 231, -111,  45, -13 },
 { -11,  40, -101, 213, -407, 750, -1477, 4506, 5778, -1626, 809, -438, 231, -112,  45, -13 },
 { -11,  40, -101, 213, -406, 748, -1473, 4485, 5797, -1627, 809, -438, 231, -112,  45, -13 },
 { -11,  40, -101, 212, -405, 746, -1469, 4464, 5817, -1628, 809, -438, 231, -112,  45, -13 },
 { -11,  40, -100, 211, -404, 744, -1465, 4442, 5836, -1628, 809, -438, 231, -112,  45, -13 },
 { -10,  39, -100, 211, -403, 743, -1460, 4421, 5855, -1629, 809, -438, 231, -112,  46, -13 },
 { -10,  39, -100, 210, -402, 741, -1456, 4399, 5874, -1629, 809, -438, 231, -112,  46, -13 },
 { -10,  39, -99, 210, -401, 739, -1452, 4377, 5893, -1629, 808, -438, 231, -112,  46, -13 },
 { -10,  39, -99, 209, -400, 737, -1448, 4356, 5912, -1630, 808, -438, 231, -112,  46, -13 },
 { -10,  39, -99, 209, -399, 735, -1443, 4334, 5931, -1630, 808, -438, 231, -112,  46, -13 },
 { -10,  39, -99, 208, -397, 733, -1439, 4313, 5950, -1630, 808, -437, 231, -112,  46, -13 },
 { -10,  39, -98, 207, -396, 731, -1435, 4291, 5968, -1630, 808, -437, 231, -112,  46, -13 },
 { -10,  38, -98, 207, -395, 729, -1430, 4269, 5987, -1630, 807, -437, 231, -112,  46, -13 },
 { -10,  38, -98, 206, -394, 727, -1426, 4248, 6006, -1630, 807, -437, 231, -112,  46, -13 },
 { -10,  38, -97, 206, -393, 725, -1421, 4226, 6025, -1630, 807, -437, 231, -112,  46, -13 },
 { -10,  38, -97, 205, -392, 722, -1417, 4204, 6043, -1630, 806, -437, 231, -112,  46, -13 },
 { -10,  38, -97, 204, -391, 720, -1412, 4183, 6062, -1630, 806, -436, 231, -112,  46, -13 },
 { -10,  38, -96, 204, -389, 718, -1407, 4161, 6080, -1629, 805, -436, 231, -112,  46, -13 },
 { -10,  38, -96, 203, -388, 716, -1403, 4139, 6099, -1629, 805, -436, 231, -112,  46, -13 },
 { -10,  37, -96, 202, -387, 714, -1398, 4117, 6117, -1629, 804, -435, 230, -112,  46, -13 },
 { -10,  37, -95, 202, -386, 711, -1393, 4096, 6135, -1628, 804, -435, 230, -112,  46, -13 },
 { -10,  37, -95, 201, -385, 709, -1388, 4074, 6153, -1628, 803, -435, 230, -111,  46, -13 },
 { -10,  37, -95, 200, -383, 707, -1384, 4052, 6172, -1627, 802, -434, 230, -111,  46, -13 },
 { -10,  37, -94, 200, -382, 705, -1379, 4030, 6190, -1626, 802, -434, 230, -111,  46, -13 },
 {  -9,  37, -94, 199, -381, 702, -1374, 4009, 6208, -1626, 801, -434, 230, -111,  46, -13 },
 {  -9,  37, -94, 198, -380, 700, -1369, 3987, 6226, -1625, 800, -433, 229, -111,  46, -13 },
 {  -9,  36, -93, 198, -378, 698, -1364, 3965, 6244, -1624, 800, -433, 229, -111,  46, -13 },
 {  -9,  36, -93, 197, -377, 695, -1359, 3943, 6262, -1623, 799, -432, 229, -111,  46, -13 },
 {  -9,  36, -92, 196, -376, 693, -1354, 3921, 6279, -1622, 798, -432, 229, -111,  46, -13 },
 {  -9,  36, -92, 195, -374, 690, -1348, 3899, 6297, -1621, 797, -431, 229, -111,  46, -13 },
 {  -9,  36, -92, 195, -373, 688, -1343, 3878, 6315, -1620, 796, -431, 228, -111,  46, -13 },
 {  -9,  36, -91, 194, -372, 685, -1338, 3856, 6333, -1619, 795, -430, 228, -111,  46, -13 },
 {  -9,  35, -91, 193, -370, 683, -1333, 3834, 6350, -1617, 794, -430, 228, -111,  46, -13 },
 {  -9,  35, -91, 193, -369, 680, -1328, 3812, 6368, -1616, 793, -429, 228, -111,  46, -13 },
 {  -9,  35, -90, 192, -368, 678, -1322, 3790, 6385, -1615, 792, -429, 227, -110,  46, -13 },
 {  -9,  35, -90, 191, -366, 675, -1317, 3768, 6403, -1613, 791, -428, 227, -110,  46, -13 },
 {  -9,  35, -89, 190, -365, 673, -1312, 3746, 6420, -1612, 790, -428, 227, -110,  46, -14 },
 {  -9,  35, -89, 190, -363, 670, -1306, 3725, 6437, -1610, 789, -427, 226, -110,  45, -14 },
 {  -9,  34, -89, 189, -362, 668, -1301, 3703, 6454, -1608, 788, -426, 226, -110,  45, -14 },
 {  -9,  34, -88, 188, -361, 665, -1295, 3681, 6472, -1607, 787, -426, 226, -110,  45, -14 },
 {  -9,  34, -88, 187, -359, 662, -1290, 3659, 6489, -1605, 786, -425, 225, -110,  45, -14 },
 {  -9,  34, -88, 186, -358, 660, -1284, 3637, 6506, -1603, 784, -424, 225, -110,  45, -14 },
 {  -8,  34, -87, 186, -356, 657, -1279, 3615, 6523, -1601, 783, -424, 225, -109,  45, -14 },
 {  -8,  34, -87, 185, -355, 654, -1273, 3593, 6539, -1599, 782, -423, 224, -109,  45, -14 },
 {  -8,  33, -86, 184, -353, 652, -1267, 3571, 6556, -1597, 780, -422, 224, -109,  45, -14 },
 {  -8,  33, -86, 183, -352, 649, -1262, 3549, 6573, -1595, 779, -421, 224, -109,  45, -14 },
 {  -8,  33, -86, 182, -350, 646, -1256, 3527, 6590, -1592, 778, -421, 223, -109,  45, -14 },
 {  -8,  33, -85, 182, -349, 643, -1250, 3505, 6606, -1590, 776, -420, 223, -109,  45, -13 },
 {  -8,  33, -85, 181, -347, 640, -1245, 3484, 6623, -1588, 775, -419, 222, -108,  45, -13 },
 {  -8,  33, -84, 180, -346, 638, -1239, 3462, 6639, -1585, 773, -418, 222, -108,  45, -13 },
 {  -8,  32, -84, 179, -344, 635, -1233, 3440, 6656, -1583, 772, -417, 221, -108,  45, -13 },
 {  -8,  32, -83, 178, -343, 632, -1227, 3418, 6672, -1580, 770, -416, 221, -108,  45, -13 },
 {  -8,  32, -83, 177, -341, 629, -1221, 3396, 6688, -1578, 768, -415, 221, -108,  45, -13 },
 {  -8,  32, -83, 177, -340, 626, -1215, 3374, 6705, -1575, 767, -414, 220, -107,  45, -13 },
 {  -8,  32, -82, 176, -338, 623, -1209, 3352, 6721, -1572, 765, -414, 220, -107,  45, -13 },
 {  -8,  31, -82, 175, -336, 620, -1203, 3330, 6737, -1569, 763, -413, 219, -107,  45, -13 },
 {  -8,  31, -81, 174, -335, 617, -1197, 3308, 6753, -1566, 762, -412, 219, -107,  44, -13 },
 {  -8,  31, -81, 173, -333, 614, -1191, 3287, 6769, -1563, 760, -411, 218, -107,  44, -13 },
 {  -8,  31, -81, 172, -332, 611, -1185, 3265, 6784, -1560, 758, -410, 218, -106,  44, -13 },
 {  -8,  31, -80, 171, -330, 608, -1179, 3243, 6800, -1557, 756, -409, 217, -106,  44, -13 },
 {  -7,  31, -80, 171, -328, 605, -1173, 3221, 6816, -1554, 754, -408, 217, -106,  44, -13 },
 {  -7,  30, -79, 170, -327, 602, -1167, 3199, 6832, -1551, 752, -406, 216, -106,  44, -13 },
 {  -7,  30, -79, 169, -325, 599, -1161, 3177, 6847, -1547, 750, -405, 215, -105,  44, -13 },
 {  -7,  30, -78, 168, -323, 596, -1154, 3155, 6863, -1544, 748, -404, 215, -105,  44, -13 },
 {  -7,  30, -78, 167, -322, 593, -1148, 3134, 6878, -1541, 746, -403, 214, -105,  44, -13 },
 {  -7,  30, -77, 166, -320, 590, -1142, 3112, 6893, -1537, 744, -402, 214, -105,  44, -13 },
 {  -7,  29, -77, 165, -318, 587, -1136, 3090, 6909, -1533, 742, -401, 213, -104,  44, -13 },
 {  -7,  29, -77, 164, -317, 584, -1129, 3068, 6924, -1530, 740, -400, 213, -104,  43, -13 },
 {  -7,  29, -76, 163, -315, 581, -1123, 3046, 6939, -1526, 738, -399, 212, -104,  43, -13 },
 {  -7,  29, -76, 162, -313, 578, -1117, 3025, 6954, -1522, 736, -397, 211, -103,  43, -13 },
 {  -7,  29, -75, 162, -311, 574, -1110, 3003, 6969, -1518, 733, -396, 211, -103,  43, -13 },
 {  -7,  28, -75, 161, -310, 571, -1104, 2981, 6984, -1514, 731, -395, 210, -103,  43, -13 },
 {  -7,  28, -74, 160, -308, 568, -1097, 2959, 6998, -1510, 729, -394, 209, -103,  43, -13 },
 {  -7,  28, -74, 159, -306, 565, -1091, 2938, 7013, -1506, 726, -392, 209, -102,  43, -13 },
 {  -7,  28, -73, 158, -304, 562, -1084, 2916, 7028, -1502, 724, -391, 208, -102,  43, -13 },
 {  -7,  28, -73, 157, -303, 558, -1078, 2894, 7042, -1497, 722, -390, 207, -102,  43, -13 },
 {  -7,  28, -73, 156, -301, 555, -1071, 2872, 7057, -1493, 719, -388, 207, -101,  43, -13 },
 {  -6,  27, -72, 155, -299, 552, -1065, 2851, 7071, -1489, 717, -387, 206, -101,  42, -13 },
 {  -6,  27, -72, 154, -297, 549, -1058, 2829, 7086, -1484, 714, -386, 205, -101,  42, -13 },
 {  -6,  27, -71, 153, -296, 545, -1052, 2807, 7100, -1480, 712, -384, 205, -100,  42, -13 },
 {  -6,  27, -71, 152, -294, 542, -1045, 2786, 7114, -1475, 709, -383, 204, -100,  42, -13 },
 {  -6,  27, -70, 151, -292, 539, -1038, 2764, 7128, -1470, 706, -381, 203, -100,  42, -13 },
 {  -6,  26, -70, 150, -290, 535, -1032, 2743, 7142, -1465, 704, -380, 202, -99,  42, -13 },
 {  -6,  26, -69, 149, -288, 532, -1025, 2721, 7156, -1461, 701, -378, 202, -99,  42, -13 },
 {  -6,  26, -69, 148, -286, 529, -1018, 2699, 7170, -1456, 698, -377, 201, -99,  41, -13 },
 {  -6,  26, -68, 147, -285, 525, -1012, 2678, 7184, -1451, 696, -375, 200, -98,  41, -13 },
 {  -6,  26, -68, 146, -283, 522, -1005, 2656, 7197, -1446, 693, -374, 199, -98,  41, -13 },
 {  -6,  25, -67, 145, -281, 518, -998, 2635, 7211, -1440, 690, -372, 198, -97,  41, -13 },
 {  -6,  25, -67, 144, -279, 515, -991, 2613, 7225, -1435, 687, -371, 198, -97,  41, -13 },
 {  -6,  25, -66, 143, -277, 512, -985, 2592, 7238, -1430, 684, -369, 197, -97,  41, -13 },
 {  -6,  25, -66, 142, -275, 508, -978, 2570, 7251, -1424, 681, -368, 196, -96,  41, -13 },
 {  -6,  25, -65, 141, -273, 505, -971, 2549, 7265, -1419, 678, -366, 195, -96,  40, -13 },
 {  -6,  24, -65, 140, -272, 501, -964, 2528, 7278, -1413, 675, -364, 194, -96,  40, -13 },
 {  -6,  24, -64, 139, -270, 498, -957, 2506, 7291, -1408, 672, -363, 193, -95,  40, -12 },
 {  -6,  24, -64, 138, -268, 494, -950, 2485, 7304, -1402, 669, -361, 192, -95,  40, -12 },
 {  -5,  24, -64, 137, -266, 491, -943, 2463, 7317, -1396, 666, -359, 192, -94,  40, -12 },
 {  -5,  24, -63, 136, -264, 487, -936, 2442, 7330, -1391, 663, -358, 191, -94,  40, -12 },
 {  -5,  23, -63, 135, -262, 484, -929, 2421, 7342, -1385, 660, -356, 190, -93,  40, -12 },
 {  -5,  23, -62, 134, -260, 480, -922, 2399, 7355, -1379, 657, -354, 189, -93,  39, -12 },
 {  -5,  23, -62, 133, -258, 477, -916, 2378, 7368, -1373, 654, -352, 188, -93,  39, -12 },
 {  -5,  23, -61, 132, -256, 473, -909, 2357, 7380, -1366, 650, -351, 187, -92,  39, -12 },
 {  -5,  23, -61, 131, -254, 470, -902, 2336, 7393, -1360, 647, -349, 186, -92,  39, -12 },
 {  -5,  22, -60, 130, -252, 466, -894, 2315, 7405, -1354, 644, -347, 185, -91,  39, -12 },
 {  -5,  22, -60, 129, -251, 463, -887, 2293, 7417, -1348, 640, -345, 184, -91,  38, -12 },
 {  -5,  22, -59, 128, -249, 459, -880, 2272, 7429, -1341, 637, -343, 183, -90,  38, -12 },
 {  -5,  22, -59, 127, -247, 455, -873, 2251, 7442, -1335, 634, -341, 182, -90,  38, -12 },
 {  -5,  22, -58, 126, -245, 452, -866, 2230, 7454, -1328, 630, -339, 181, -89,  38, -12 },
 {  -5,  21, -58, 125, -243, 448, -859, 2209, 7465, -1321, 627, -338, 180, -89,  38, -12 },
 {  -5,  21, -57, 124, -241, 445, -852, 2188, 7477, -1315, 623, -336, 179, -88,  38, -12 },
 {  -5,  21, -57, 123, -239, 441, -845, 2167, 7489, -1308, 619, -334, 178, -88,  37, -12 },
 {  -5,  21, -56, 122, -237, 437, -838, 2146, 7501, -1301, 616, -332, 177, -87,  37, -12 },
 {  -5,  21, -56, 121, -235, 434, -831, 2125, 7512, -1294, 612, -330, 176, -87,  37, -12 },
 {  -5,  20, -55, 120, -233, 430, -823, 2104, 7524, -1287, 609, -328, 175, -86,  37, -12 },
 {  -4,  20, -55, 119, -231, 426, -816, 2083, 7535, -1280, 605, -326, 174, -86,  37, -12 },
 {  -4,  20, -54, 118, -229, 423, -809, 2062, 7546, -1273, 601, -324, 173, -85,  36, -11 },
 {  -4,  20, -54, 117, -227, 419, -802, 2041, 7557, -1266, 597, -322, 172, -85,  36, -11 },
 {  -4,  20, -53, 116, -225, 415, -795, 2021, 7569, -1258, 594, -320, 171, -84,  36, -11 },
 {  -4,  19, -53, 115, -223, 412, -788, 2000, 7580, -1251, 590, -318, 170, -84,  36, -11 },
 {  -4,  19, -52, 114, -221, 408, -780, 1979, 7590, -1243, 586, -315, 169, -83,  35, -11 },
 {  -4,  19, -52, 113, -219, 404, -773, 1958, 7601, -1236, 582, -313, 167, -83,  35, -11 },
 {  -4,  19, -51, 112, -217, 401, -766, 1938, 7612, -1228, 578, -311, 166, -82,  35, -11 },
 {  -4,  19, -51, 111, -215, 397, -759, 1917, 7623, -1220, 574, -309, 165, -82,  35, -11 },
 {  -4,  18, -50, 109, -213, 393, -751, 1896, 7633, -1213, 570, -307, 164, -81,  35, -11 },
 {  -4,  18, -50, 108, -211, 389, -744, 1876, 7644, -1205, 566, -305, 163, -81,  34, -11 },
 {  -4,  18, -49, 107, -209, 386, -737, 1855, 7654, -1197, 562, -302, 162, -80,  34, -11 },
 {  -4,  18, -49, 106, -207, 382, -729, 1835, 7664, -1189, 558, -300, 160, -79,  34, -11 },
 {  -4,  18, -48, 105, -205, 378, -722, 1814, 7674, -1181, 554, -298, 159, -79,  34, -11 },
 {  -4,  17, -48, 104, -203, 374, -715, 1794, 7685, -1173, 550, -296, 158, -78,  33, -11 },
 {  -4,  17, -47, 103, -201, 371, -708, 1774, 7695, -1164, 546, -294, 157, -78,  33, -11 },
 {  -4,  17, -47, 102, -199, 367, -700, 1753, 7704, -1156, 541, -291, 156, -77,  33, -11 },
 {  -4,  17, -46, 101, -196, 363, -693, 1733, 7714, -1148, 537, -289, 154, -77,  33, -10 },
 {  -3,  17, -46, 100, -194, 359, -686, 1712, 7724, -1139, 533, -287, 153, -76,  32, -10 },
 {  -3,  16, -45,  99, -192, 356, -678, 1692, 7734, -1131, 529, -284, 152, -75,  32, -10 },
 {  -3,  16, -45,  98, -190, 352, -671, 1672, 7743, -1122, 524, -282, 151, -75,  32, -10 },
 {  -3,  16, -44,  97, -188, 348, -664, 1652, 7753, -1113, 520, -280, 149, -74,  32, -10 },
 {  -3,  16, -44,  96, -186, 344, -656, 1632, 7762, -1105, 516, -277, 148, -74,  31, -10 },
 {  -3,  16, -43,  94, -184, 340, -649, 1612, 7771, -1096, 511, -275, 147, -73,  31, -10 },
 {  -3,  15, -43,  93, -182, 337, -641, 1591, 7780, -1087, 507, -272, 146, -72,  31, -10 },
 {  -3,  15, -42,  92, -180, 333, -634, 1571, 7789, -1078, 502, -270, 144, -72,  31, -10 },
 {  -3,  15, -42,  91, -178, 329, -627, 1551, 7798, -1069, 498, -267, 143, -71,  30, -10 },
 {  -3,  15, -41,  90, -176, 325, -619, 1531, 7807, -1060, 493, -265, 142, -70,  30, -10 },
 {  -3,  15, -41,  89, -174, 321, -612, 1512, 7816, -1050, 489, -262, 140, -70,  30, -10 },
 {  -3,  15, -40,  88, -172, 318, -605, 1492, 7825, -1041, 484, -260, 139, -69,  30, -10 },
 {  -3,  14, -40,  87, -170, 314, -597, 1472, 7833, -1032, 479, -257, 138, -68,  29,  -9 },
 {  -3,  14, -39,  86, -168, 310, -590, 1452, 7842, -1022, 475, -255, 136, -68,  29,  -9 },
 {  -3,  14, -38,  85, -165, 306, -582, 1432, 7850, -1013, 470, -252, 135, -67,  29,  -9 },
 {  -3,  14, -38,  84, -163, 302, -575, 1413, 7858, -1003, 465, -250, 134, -66,  29,  -9 },
 {  -3,  14, -37,  83, -161, 298, -568, 1393, 7866, -994, 460, -247, 132, -66,  28,  -9 },
 {  -3,  13, -37,  81, -159, 295, -560, 1373, 7874, -984, 456, -245, 131, -65,  28,  -9 },
 {  -3,  13, -36,  80, -157, 291, -553, 1354, 7882, -974, 451, -242, 130, -64,  28,  -9 },
 {  -3,  13, -36,  79, -155, 287, -545, 1334, 7890, -964, 446, -239, 128, -64,  27,  -9 },
 {  -2,  13, -35,  78, -153, 283, -538, 1315, 7898, -954, 441, -237, 127, -63,  27,  -9 },
 {  -2,  13, -35,  77, -151, 279, -531, 1295, 7906, -944, 436, -234, 125, -62,  27,  -9 },
 {  -2,  12, -34,  76, -149, 275, -523, 1276, 7913, -934, 431, -231, 124, -62,  27,  -9 },
 {  -2,  12, -34,  75, -147, 271, -516, 1256, 7921, -924, 426, -229, 122, -61,  26,  -8 },
 {  -2,  12, -33,  74, -145, 268, -508, 1237, 7928, -914, 421, -226, 121, -60,  26,  -8 },
 {  -2,  12, -33,  73, -142, 264, -501, 1218, 7936, -903, 416, -223, 120, -60,  26,  -8 },
 {  -2,  12, -32,  72, -140, 260, -494, 1199, 7943, -893, 411, -220, 118, -59,  25,  -8 },
 {  -2,  11, -32,  71, -138, 256, -486, 1179, 7950, -882, 406, -218, 117, -58,  25,  -8 },
 {  -2,  11, -31,  70, -136, 252, -479, 1160, 7957, -872, 401, -215, 115, -57,  25,  -8 },
 {  -2,  11, -31,  68, -134, 248, -471, 1141, 7964, -861, 396, -212, 114, -57,  24,  -8 },
 {  -2,  11, -30,  67, -132, 244, -464, 1122, 7971, -850, 391, -209, 112, -56,  24,  -8 },
 {  -2,  11, -30,  66, -130, 241, -457, 1103, 7977, -840, 385, -207, 111, -55,  24,  -8 },
 {  -2,  10, -29,  65, -128, 237, -449, 1084, 7984, -829, 380, -204, 109, -54,  23,  -8 },
 {  -2,  10, -29,  64, -126, 233, -442, 1065, 7990, -818, 375, -201, 108, -54,  23,  -7 },
 {  -2,  10, -28,  63, -124, 229, -434, 1046, 7997, -807, 370, -198, 106, -53,  23,  -7 },
 {  -2,  10, -28,  62, -122, 225, -427, 1028, 8003, -796, 364, -195, 105, -52,  22,  -7 },
 {  -2,  10, -27,  61, -119, 221, -420, 1009, 8009, -784, 359, -192, 103, -51,  22,  -7 },
 {  -2,  10, -27,  60, -117, 217, -412, 990, 8015, -773, 354, -189, 101, -51,  22,  -7 },
 {  -2,   9, -26,  59, -115, 214, -405, 971, 8021, -762, 348, -186, 100, -50,  22,  -7 },
 {  -2,   9, -26,  58, -113, 210, -398, 953, 8027, -751, 343, -184,  98, -49,  21,  -7 },
 {  -2,   9, -25,  57, -111, 206, -390, 934, 8033, -739, 337, -181,  97, -48,  21,  -7 },
 {  -1,   9, -25,  56, -109, 202, -383, 916, 8039, -728, 332, -178,  95, -47,  21,  -7 },
 {  -1,   9, -24,  54, -107, 198, -375, 897, 8044, -716, 326, -175,  94, -47,  20,  -7 },
 {  -1,   8, -24,  53, -105, 194, -368, 879, 8050, -704, 321, -172,  92, -46,  20,  -6 },
 {  -1,   8, -23,  52, -103, 190, -361, 861, 8055, -693, 315, -169,  90, -45,  19,  -6 },
 {  -1,   8, -23,  51, -101, 187, -353, 842, 8060, -681, 310, -166,  89, -44,  19,  -6 },
 {  -1,   8, -22,  50, -99, 183, -346, 824, 8065, -669, 304, -163,  87, -44,  19,  -6 },
 {  -1,   8, -22,  49, -97, 179, -339, 806, 8071, -657, 298, -160,  86, -43,  18,  -6 },
 {  -1,   7, -21,  48, -94, 175, -331, 788, 8075, -645, 293, -157,  84, -42,  18,  -6 },
 {  -1,   7, -21,  47, -92, 171, -324, 770, 8080, -633, 287, -153,  82, -41,  18,  -6 },
 {  -1,   7, -20,  46, -90, 167, -317, 752, 8085, -621, 281, -150,  81, -40,  17,  -6 },
 {  -1,   7, -20,  45, -88, 164, -310, 734, 8090, -608, 275, -147,  79, -39,  17,  -5 },
 {  -1,   7, -19,  44, -86, 160, -302, 716, 8094, -596, 270, -144,  77, -39,  17,  -5 },
 {  -1,   7, -19,  43, -84, 156, -295, 698, 8099, -584, 264, -141,  76, -38,  16,  -5 },
 {  -1,   6, -19,  42, -82, 152, -288, 680, 8103, -571, 258, -138,  74, -37,  16,  -5 },
 {  -1,   6, -18,  41, -80, 148, -280, 662, 8107, -559, 252, -135,  72, -36,  16,  -5 },
 {  -1,   6, -18,  39, -78, 144, -273, 644, 8112, -546, 246, -132,  71, -35,  15,  -5 },
 {  -1,   6, -17,  38, -76, 141, -266, 627, 8116, -533, 240, -128,  69, -34,  15,  -5 },
 {  -1,   6, -17,  37, -74, 137, -259, 609, 8119, -520, 235, -125,  67, -34,  14,  -5 },
 {  -1,   5, -16,  36, -72, 133, -251, 592, 8123, -508, 229, -122,  65, -33,  14,  -5 },
 {  -1,   5, -16,  35, -70, 129, -244, 574, 8127, -495, 223, -119,  64, -32,  14,  -4 },
 {  -1,   5, -15,  34, -68, 125, -237, 557, 8131, -482, 217, -116,  62, -31,  13,  -4 },
 {  -1,   5, -15,  33, -65, 122, -230, 539, 8134, -469, 211, -112,  60, -30,  13,  -4 },
 {  -1,   5, -14,  32, -63, 118, -223, 522, 8138, -456, 205, -109,  59, -29,  13,  -4 },
 {  -1,   5, -14,  31, -61, 114, -215, 505, 8141, -442, 198, -106,  57, -28,  12,  -4 },
 {  -1,   4, -13,  30, -59, 110, -208, 488, 8144, -429, 192, -103,  55, -27,  12,  -4 },
 {   0,   4, -13,  29, -57, 106, -201, 470, 8147, -416, 186, -99,  53, -27,  11,  -4 },
 {   0,   4, -12,  28, -55, 103, -194, 453, 8150, -402, 180, -96,  51, -26,  11,  -3 },
 {   0,   4, -12,  27, -53,  99, -187, 436, 8153, -389, 174, -93,  50, -25,  11,  -3 },
 {   0,   4, -11,  26, -51,  95, -180, 419, 8156, -375, 168, -89,  48, -24,  10,  -3 },
 {   0,   4, -11,  25, -49,  91, -173, 402, 8159, -362, 162, -86,  46, -23,  10,  -3 },
 {   0,   3, -10,  24, -47,  88, -166, 386, 8161, -348, 155, -83,  44, -22,   9,  -3 },
 {   0,   3, -10,  23, -45,  84, -158, 369, 8164, -334, 149, -79,  43, -21,   9,  -3 },
 {   0,   3,  -9,  22, -43,  80, -151, 352, 8166, -321, 143, -76,  41, -20,   9,  -3 },
 {   0,   3,  -9,  21, -41,  76, -144, 335, 8168, -307, 137, -73,  39, -19,   8,  -3 },
 {   0,   3,  -9,  20, -39,  73, -137, 319, 8170, -293, 130, -69,  37, -18,   8,  -2 },
 {   0,   3,  -8,  19, -37,  69, -130, 302, 8172, -279, 124, -66,  35, -18,   7,  -2 },
 {   0,   2,  -8,  18, -35,  65, -123, 286, 8174, -265, 117, -62,  33, -17,   7,  -2 },
 {   0,   2,  -7,  17, -33,  62, -116, 269, 8176, -251, 111, -59,  32, -16,   7,  -2 },
 {   0,   2,  -7,  15, -31,  58, -109, 253, 8178, -236, 105, -56,  30, -15,   6,  -2 },
 {   0,   2,  -6,  14, -29,  54, -102, 237, 8180, -222,  98, -52,  28, -14,   6,  -2 },
 {   0,   2,  -6,  13, -27,  50, -95, 220, 8181, -208,  92, -49,  26, -13,   5,  -2 },
 {   0,   2,  -5,  12, -25,  47, -88, 204, 8183, -193,  85, -45,  24, -12,   5,  -1 },
 {   0,   1,  -5,  11, -23,  43, -81, 188, 8184, -179,  79, -42,  22, -11,   5,  -1 },
 {   0,   1,  -4,  10, -21,  39, -75, 172, 8185, -164,  72, -38,  20, -10,   4,  -1 },
 {   0,   1,  -4,   9, -19,  36, -68, 156, 8186, -149,  66, -35,  19,  -9,   4,  -1 },
 {   0,   1,  -3,   8, -17,  32, -61, 140, 8187, -135,  59, -31,  17,  -8,   3,  -1 },
 {   0,   1,  -3,   7, -15,  28, -54, 124, 8188, -120,  53, -28,  15,  -7,   3,  -1 },
 {   0,   1,  -3,   6, -13,  25, -47, 108, 8189, -105,  46, -24,  13,  -6,   3,  -1 },
 {   0,   0,  -2,   5, -11,  21, -40,  93, 8190, -90,  40, -21,  11,  -5,   2,   0 },
 {   0,   0,  -2,   4,  -9,  18, -33,  77, 8190, -75,  33, -17,   9,  -4,   2,   0 },
 {   0,   0,  -1,   3,  -7,  14, -27,  61, 8191, -60,  26, -14,   7,  -3,   1,   0 },
 {   0,   0,  -1,   2,  -5,  10, -20,  46, 8191, -45,  20, -10,   5,  -2,   1,   0 },
 {   0,   0,   0,   1,  -3,   7, -13,  30, 8191, -30,  13,  -7,   3,  -1,   0,   0 },
 {   0,   0,   0,   0,  -1,   3,  -6,  15, 8191, -15,   6,  -3,   1,   0,   0,   0 },
};
#endif

