/****************************************************************************
**
** This file is part of the Qt Extended Opensource Package.
**
** Copyright (C) 2009 Trolltech ASA.
**
** Contact: Qt Extended Information (info@qtextended.org)
**
** This file may be used under the terms of the GNU General Public License
** version 2.0 as published by the Free Software Foundation and appearing
** in the file LICENSE.GPL included in the packaging of this file.
**
** Please review the following information to ensure GNU General Public
** Licensing requirements will be met:
**     http://www.fsf.org/licensing/licenses/info/GPLv2.html.
**
**
****************************************************************************/

#ifndef QBLUETOOTHDEFAULTPASSKEYAGENT_H
#define QBLUETOOTHDEFAULTPASSKEYAGENT_H

#include <qbluetoothpasskeyagent.h>

class QPasswordDialog;

class QBLUETOOTH_EXPORT QBluetoothDefaultPasskeyAgent : public QBluetoothPasskeyAgent {
    Q_OBJECT
public:
    explicit QBluetoothDefaultPasskeyAgent(const QString &name, QObject *parent = 0);
    ~QBluetoothDefaultPasskeyAgent();

    virtual void requestPasskey(QBluetoothPasskeyRequest &req);
    virtual void cancelRequest(const QString &localDevice,
                               const QBluetoothAddress &remoteAddr);
    virtual void release();

private slots:
    void stopVibration();

private:
    QPasswordDialog *m_passDialog;
};

#endif
