/*
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies)
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY NOKIA CORPORATION ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef ApplicationWindowHost_h
#define ApplicationWindowHost_h

#include <QMainWindow>

#include "ApplicationWindow.h"

class ApplicationWindowHost : public QMainWindow
{
    friend class ApplicationWindow;

public:
    ~ApplicationWindowHost();

#if defined(Q_WS_MAEMO_5)
#if QT_VERSION < QT_VERSION_CHECK(4, 6, 2)
protected Q_SLOTS:
    void orientationChanged(const QString&);
#endif
#endif

#ifdef QTOPIA
protected:
    bool event(QEvent *ev);
#endif

private:
    ApplicationWindowHost();

    void setApplicationWindow(ApplicationWindow* item);

#if defined(Q_WS_MAEMO_5)
    void grabIncreaseDecreaseKeys(QWidget* window, bool grab);
#endif

private:
    ApplicationWindow* m_mainView;
};



#endif
