#include <string.h>
#include <unistd.h>

void help() {
    const char *help =

"gta02-gps\n"
"\n"
"INVOCATION\n"
"==========\n"
"\n"
"    gta02-gps --help\n"
"    gta02-gps [--verbose] --setup-serial <device-file>\n"
"    gta02-gps [--verbose] [--setup-serial] <device-file> --load-agps <agps-path>\n"
"    gta02-gps [--verbose] [--setup-serial] <device-file> --dump-agps <agps-path>\n"
"    gta02-gps [--verbose] [--setup-serial] <device-file> --sleep\n"
"    gta02-gps [--verbose] [--setup-serial] <device-file> --wake-up\n"
"\n"
"INFORMATION\n"
"===========\n"
"\n"
"These programs can set up the UBX GPS chip to obtain\n"
"faster fix after powering on (TTFF). To do this it\n"
"needs AGPS information.\n"
"\n"
"The AGPS information can be grabbed from GPS chip\n"
"when it has fix (reports valid position). Do:\n"
"\n"
"    gta02-gps /dev/ttySAC1 --setup-serial --dump-agps agpsdata\n"
"\n"
"This will save AGPS data read from chip into the\n"
"file \"agpsdata\" (it can be passed as a full path).\n"
"\n"
"This data can be loaded into the GPS after it is\n"
"stopped and started again. This should improve TTFF.\n"
"\n"
"To load data from agpsdata file issue:\n"
"\n"
"    gta02-gps /dev/ttySAC1 --setup-serial --load-agps agpsdata\n"
"\n"
"Passing -h or --help argument gives you this message.\n"
"\n"
"    gta02-gps --help\n"
"\n"
"Passing -v or --verbose argument prints some debug\n"
"information while operating.\n"
"\n"
"You can use \"-\" instead of the device name, to let the\n"
"application communicate through standard input/output.\n"
"For example:\n"
"\n"
"    gta02-gps - --load-agps agpsdata\n"
"\n"
"This may be useful for debugging. In this case it\n"
"may be not possible to set up the serial interface\n"
"of the device, so may need to omit --setup-serial\n"
"option. To do the same as --setup-serial does, issue:\n"
"\n"
"    stty -F /dev/ttySAC1 raw\n"
"\n"
"FIXNOW(R)\n"
"=========\n"
"\n"
"In order to get even faster fixes you can enable\n"
"FixNow(R) technology. When you intend to disable\n"
"the GPS, you can put it to a kind of stand-by mode\n"
"instead. Waking up (instead of doing power on) gives\n"
"you TTFF of 10 seconds range.\n"
"\n"
"Instead of disabling GPS, do:\n"
"\n"
"    gta02-gps /dev/ttySAC1 --setup-serial --sleep\n"
"\n"
"Instead of enabling it again, do:\n"
"\n"
"    gta02-gps /dev/ttySAC1 --setup-serial --wake-up\n"
"\n"
"You need to have GPS powered on to do this kind\n"
"of things. Note this will drain some current, but\n"
"it should be minimal (comparing to GPS fully powered\n"
"on).\n"
"\n"
    
    ;

    write(2, help, strlen(help));
}

