gta02-gps

INVOCATION
==========

    gta02-gps --help
    gta02-gps [--verbose] --setup-serial <device-file>
    gta02-gps [--verbose] [--setup-serial] <device-file> --load-agps <agps-path>
    gta02-gps [--verbose] [--setup-serial] <device-file> --dump-agps <agps-path>
    gta02-gps [--verbose] [--setup-serial] <device-file> --sleep
    gta02-gps [--verbose] [--setup-serial] <device-file> --wake-up

INFORMATION
===========

These programs can set up the UBX GPS chip to obtain
faster fix after powering on (TTFF). To do this it
needs AGPS information.

The AGPS information can be grabbed from GPS chip
when it has fix (reports valid position). Do:

    gta02-gps /dev/ttySAC1 --setup-serial --dump-agps agpsdata

This will save AGPS data read from chip into the
file "agpsdata" (it can be passed as a full path).

This data can be loaded into the GPS after it is
stopped and started again. This should improve TTFF.

To load data from agpsdata file issue:

    gta02-gps /dev/ttySAC1 --setup-serial --load-agps agpsdata

Passing -h or --help argument gives you this message.

    gta02-gps --help

Passing -v or --verbose argument prints some debug
information while operating.

You can use "-" instead of the device name, to let the
application communicate through standard input/output.
For example:

    gta02-gps - --load-agps agpsdata

This may be useful for debugging. In this case it
may be not possible to set up the serial interface
of the device, so may need to omit --setup-serial
option. To do the same as --setup-serial does, issue:

    stty -F /dev/ttySAC1 raw

FIXNOW(R)
=========

In order to get even faster fixes you can enable
FixNow(R) technology. When you intend to disable
the GPS, you can put it to a kind of stand-by mode
instead. Waking up (instead of doing power on) gives
you TTFF of 10 seconds range.

Instead of disabling GPS, do:

    gta02-gps /dev/ttySAC1 --setup-serial --sleep

Instead of enabling it again, do:

    gta02-gps /dev/ttySAC1 --setup-serial --wake-up

You need to have GPS powered on to do this kind
of things. Note this will drain some current, but
it should be minimal (comparing to GPS fully powered
on).

SUSPEND
=======

Putting your FreeRunner into suspend makes GPS chip
forget AGPS data and the position/time, so after
waking up, you have a true cold start of the GPS.

Dumping AGPS data before suspending FreeRunner and
loading the same data after waking up makes it a
warm start.

You can also keep GPS powered during suspend, by
using om utility:

    om gps keep-on-in-suspend 1

This drains your battery, so may want to use it in
tandem with gta02-gps /dev/ttySAC1 --setup-serial
--sleep. This is not yet heavily tested, but should
work.

STORAGE FORMAT
==============

AGPS data is saved as UBX messages (the same format
you communicate with the device). For AID_ALM and
AID_EPH data it's nice, because on load you send
excatly the same message you dumped before. For
NAV_ESECEF and AID_HUI, program needs to grab only
parts of them and send different message to chip
AID_INI and a modified AID_HUI. This means program
needs to read the messages from file and parse them,
but that's not such a big problem.

COMPILING
=========

Compile programs with:

    gcc -fpack-struct gta02-gps.c -o gta02-gps

The code is also compilable by g++ C++ compiler.

-fpack-struct is needed, because one of the structs
in ubx.h is not properly aligned and so will be
padded if -fpack-struct is not passed.

Makefile should do the job, just type:

    make

To have things compiled.

LICENSE
=======

Code licensed on GPLv2. Written by:

(C) 2010 Piotr Gabryjeluk <piotr@gabryjeluk.pl>

ubx.h header file is distributed on BSD-like license
(for details consult the file) auto-generated by:

Copyright (C) u-blox ag

Code inspired (and partially borrowed) from
Open GPS Daemon by

(C) 2008 Jan 'Shoragan' Lübbe <jluebbe@lasnet.de>
(C) 2008 Daniel Willmann <daniel@totalueberwachung.de>
(C) 2008 Openmoko, Inc.
licensed on GPLv2

Code inspired (and partially borrowed) from
http://iki.fi/lindi/git/ubx.git by:

Copyright (C) 2010 Timo Juhani Lindfors <timo.lindfors@iki.fi>
licensed on MIT license
