/****************************************************************************
 **
 ** Copyright (C) 2007-2007 TROLLTECH ASA. All rights reserved.
 **
 ** This file is part of the Opensource Edition of the Qtopia Toolkit.
 **
 ** This software is licensed under the terms of the GNU General Public
 ** License (GPL) version 2.
 **
 ** See http://www.trolltech.com/gpl/ for GPL licensing information.
 **
 ** Contact info@trolltech.com if any conditions of this licensing are
 ** not clear to you.
 **
 **
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/

#ifndef _HTCUNIVERSALBATTERY_H_
#define _HTCUNIVERSALBATTERY_H_

#include <QObject>
#include <QSocketNotifier>

#define BATTERY_CLASS "/sys/class/power_supply/ds2760-battery.0"
#define AC_CLASS "/sys/class/power_supply/usb"

class QPowerSourceProvider;

class HtcuniversalBattery : public QObject
{
  Q_OBJECT
    public:
  HtcuniversalBattery(QObject *parent = 0);

 protected:
  virtual void timerEvent(QTimerEvent *);

 private:
  int percentCharge;
  int fullCharge,emptyCharge;
  QString readValue( QString file );
 

  QPowerSourceProvider *ac;
  QPowerSourceProvider *battery;

  private Q_SLOTS:
    void updateUniversalStatus();
};

#endif // _HTCUNIVERSALBATTERY_H_
