/****************************************************************************
**
** This file is part of the Qt Extended Opensource Package.
**
** Copyright (C) 2009 Trolltech ASA.
**
** Contact: Qt Extended Information (info@qtextended.org)
**
** This file may be used under the terms of the GNU General Public License
** version 2.0 as published by the Free Software Foundation and appearing
** in the file LICENSE.GPL included in the packaging of this file.
**
** Please review the following information to ensure GNU General Public
** Licensing requirements will be met:
**     http://www.fsf.org/licensing/licenses/info/GPLv2.html.
**
**
****************************************************************************/
#include "fixbdaddr.h"

#include <qtopiaapplication.h>
#include <qsoftmenubar.h>
#include <qtelephonyconfiguration.h>
#include <qlog.h>

#include <QWaitWidget>
#include <QMessageBox>

#include <QListWidget>
#include <QVBoxLayout>
#include <QMenu>

#include <string.h>
#include "../../../include/docparatable.h"
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

const QString option1 = QObject::tr("Set Address (Yuhuatel Dist)");
const QString option2 = QObject::tr("Set Address (IMEI Based, Unsafe)");

/* If you must change this, always APPEND!!! */
const char *imeis[] = {
    "348731009980330",
    "358731009980184",
    "358731009980309",
    "358731009980135",
    "358731009980796",
    "358731009980614",
    "358731009980176",
    "358731009980333",
    "358731009980598",
    "358731009980721",
    "358731009979970",
    "358731009980119",
    "358731009980739",
    "358731009979871",
    "358731009980143",
    "358731009979913",
    "358731009980861",
    "358731009979905",
    "358731009980390",
    "358731009980929",
    "358731009980267",
    "358731009980192",
    "358731009980903",
    "358731009980507",
    "358731009980036",
    "358731009980572",
    "358731009980523",
    "358731009980481",
    "358731009980648",
    "358731009980325",
    "358731009980077",
    "358731009980408",
    "358731009980754",
    "358731009979863",
    "358731009980242",
    "358731009979897",
    "358731009980150",
    "358731009979988",
    "358731009980606",
    "358731009980622",
    "358731009980747",
    "358731009980846",
    "358731009980564",
    "358731009979889",
    "358731009980283",
    "358731009980895",
    "358731009980697",
    "358731009980440",
    "358731009984905",
    NULL
};

const char *imeisdvt4[] = {
    "358731009988302",
    "358731009988161",
    "358731009988179",
    "358731009984376",
    "358731009988310",
    "358731009988336",
    "358731009988260",
    "358731009988278",
    "358731009988245",
    "358731009988146",
    "358731009988286",
    "358731009988187",
    "358731009988229",
    "358731009988203",
    "358731009990746",
    "358731009985183",
    "358731009988344",
    "358731009988153",
    "358731009988328",
    "358731009983386",
    "358731009988195",
    "358731009988054",
    "358731009987940",
    "358731009987908",
    "358731009988112",
    "358731009988047",
    "358731009987890",
    "358731009987916",
    "358731009988013",
    "358731009988237",
    "358731009988138",
    "358731009987999",
    "358731009987924",
    "358731009987957",
    "358731009987866",
    "358731009988104",
    "358731009988088",
    "358731009987882",
    "358731009988211",
    "358731009988005",
    "358731009985357",
    "358731009987981",
    "358731009987932",
    "358731009987874",
    "358731009988120",
    "358731009988062",
    "358731009988070",
    "358731009987973",
    "358731009987858",
    "358731009988096",
    "358731009983907",
    "358731009983980",
    "358731009983915",
    "358731009984095",
    "358731009983774",
    "358731009983923",
    "358731009983782",
    "358731009983790",
    "358731009983428",
    "358731009983444",
    "358731009984897",
    "358731009983402",
    "358731009985225",
    "358731009984673",
    "358731009990472",
    "358731009984905",
    "358731009984889",
    "358731009984871",
    "358731009985118",
    "358731009983410",
    "358731009985381",
    "358731009984699",
    "358731009984756",
    "358731009983436",
    "358731009984707",
    "358731009984921",
    "358731009984681",
    "358731009985464",
    "358731009985092",
    "358731009989169",
    "358731009989193",
    "358731009984764",
    "358731009988989",
    "358731009988930",
    "358731009988971",
    "358731009987965",
    "358731009989029",
    "358731009988963",
    "358731009992023",
    "358731009988021",
    "358731009986736",
    "358731009989128",
    "358731009990720",
    "358731009989250",
    "358731009989276",
    "358731009989235",
    "358731009990761",
    "358731009989136",
    "358731009989177",
    "358731009989011",
    "358731009985662",
    "358731009987155",
    "358731009986520",
    "358731009985647",
    "358731009986967",
    "358731009985712",
    "358731009985738",
    "358731009986702",
    "358731009985860",
    "358731009985696",
    "358731009987171",
    "358731009986728",
    "358731009992247",
    "358731009986322",
    "358731009986744",
    "358731009984939",
    "358731009984863",
    "358731009986496",
    "358731009989995",
    "358731009989961",
    "358731009987213",
    "358731009987197",
    "358731009987247",
    "358731009986389",
    "358731009985613",
    "358731009990506",
    "358731009985803",
    "358731009986488",
    "358731009986397",
    "358731009985852",
    "358731009986934",
    "358731009986710",
    "358731009985605",
    "358731009987106",
    "358731009987122",
    "358731009990522",
    "358731009987239",
    "358731009990480",
    "358731009990548",
    "358731009985621",
    "358731009986454",
    "358731009987189",
    "358731009987031",
    "358731009986751",
    "358731009991793",
    "358731009986942",
    "358731009985514",
    "358731009986363",
    "358731009987221",
    "358731009987064",
    "358731009991389",
    "358731009991512",
    "358731009991553",
    "358731009991546",
    "358731009991645",
    "358731009991355",
    "358731009991405",
    "358731009991769",
    "358731009991629",
    "358731009991777",
    "358731009991330",
    "358731009991488",
    "358731009991322",
    "358731009991462",
    "358731009991785",
    "358731009991439",
    "358731009991694",
    "358731009991306",
    "358731009991751",
    "358731009991637",
    "358731009991660",
    "358731009991702",
    "358731009991363",
    "358731009991728",
    "358731009991561",
    "358731009991579",
    "358731009991371",
    "358731009991678",
    "358731009991454",
    "358731009989102",
    "358731009989052",
    "358731009989342",
    "358731009991587",
    "358731009991595",
    "358731009991652",
    "358731009988948",
    "358731009989292",
    "358731009989359",
    "358731009989219",
    "358731009989094",
    "358731009983709",
    "358731009986348",
    "358731009992619",
    "358731009984574",
    "358731009984822",
    "358731009992536",
    "358731009992189",
    "358731009992759",
    "358731009992767",
    "358731009992544",
    "358731009984152",
    "358731009983956",
    "358731009984236",
    "358731009983592",
    "358731009983832",
    "358731009984079",
    "358731009984814",
    "358731009983717",
    "358731009984582",
    "358731009992445",
    "358731009983857",
    "358731009983840",
    "358731009983642",
    "358731009984343",
    "358731009983824",
    "358731009983675",
    "358731009984772",
    "358731009983634",
    "358731009983626",
    "358731009984798",
    "358731009983881",
    "358731009983816",
    "358731009984491",
    "358731009983873",
    "358731009984046",
    "358731009984467",
    "358731009983618",
    "358731009983535",
    "358731009985811",
    "358731009984327",
    "358731009983899",
    "358731009983865",
    "358731009983527",
    "358731009984020",
    "358731009983758",
    "358731009984053",
    "358731009983733",
    "358731009983600",
    "358731009983485",
    "358731009983451",
    "358731009987403",
    "358731009986629",
    "358731009987361",
    "358731009987395",
    "358731009987270",
    "358731009987429",
    "358731009987478",
    "358731009988039",
    "358731009987098",
    "358731009987072",
    "358731009987452",
    "358731009987627",
    "358731009986785",
    "358731009987254",
    "358731009987544",
    "358731009987320",
    "358731009987312",
    "358731009987551",
    "358731009987338",
    "358731009987411",
    "358731009986678",
    "358731009990324",
    "358731009987262",
    "358731009986777",
    "358731009987502",
    "358731009987379",
    "358731009987528",
    "358731009987536",
    "358731009987510",
    "358731009987387",
    "358731009986223",
    "358731009985787",
    "358731009986256",
    "358731009990449",
    "358731009987205",
    "358731009987023",
    "358731009987130",
    "358731009986900",
    "358731009987288",
    "358731009987494",
    "358731009990407",
    "358731009986991",
    "358731009987056",
    "358731009986926",
    "358731009989268",
    "358731009987304",
    "358731009990423",
    "358731009987114",
    "358731009990431",
    "358731009987296",
    "358731009990894",
    "358731009991173",
    "358731009991249",
    "358731009991298",
    "358731009991215",
    "358731009991223",
    "358731009991264",
    "358731009991256",
    "358731009991272",
    "358731009991207",
    "358731009990852",
    "358731009990860",
    "358731009991074",
    "358731009991181",
    "358731009990829",
    "358731009991165",
    "358731009991199",
    "358731009991116",
    "358731009990969",
    "358731009990928",
    "358731009990811",
    "358731009990878",
    "358731009990910",
    "358731009990977",
    "358731009991058",
    "358731009991033",
    "358731009990837",
    "358731009990845",
    "358731009990936",
    "358731009987353",
    "358731009990902",
    "358731009990944",
    "358731009990886",
    "358731009991157",
    "358731009990951",
    "358731009990993",
    "358731009991090",
    "358731009992080",
    "358731009991041",
    "358731009991066",
    "358731009986975",
    "358731009986959",
    "358731009991025",
    "358731009990985",
    "358731009991140",
    "358731009991124",
    "358731009991108",
    "358731009991009",
    "358731009991132",
    "358731009991082",
    "358731009985035",
    "358731009985142",
    "358731009984947",
    "358731009984954",
    "358731009990084",
    "358731009984962",
    "358731009985001",
    "358731009985217",
    "358731009990076",
    "358731009985456",
    "358731009990092",
    "358731009988393",
    "358731009990050",
    "358731009990126",
    "358731009990225",
    "358731009990100",
    "358731009990068",
    "358731009990118",
    "358731009988468",
    "358731009990241",
    "358731009984558",
    "358731009984632",
    "358731009984475",
    "358731009984608",
    "358731009984566",
    "358731009984590",
    "358731009984624",
    "358731009985274",
    "358731009984988",
    "358731009984442",
    "358731009984517",
    "358731009984541",
    "358731009984616",
    "358731009983964",
    "358731009984335",
    "358731009984459",
    "358731009984293",
    "358731009984350",
    "358731009984483",
    "358731009983543",
    "358731009984525",
    "358731009984509",
    "358731009985597",
    "358731009985522",
    "358731009985027",
    "358731009985563",
    "358731009985209",
    "358731009985340",
    "358731009985266",
    "358731009985324",
    "358731009990175",
    "358731009990159",
    "358731009987643",
    "358731009990191",
    "358731009989904",
    "358731009989888",
    "358731009989730",
    "358731009989714",
    "358731009987635",
    "358731009990217",
    "358731009989896",
    "358731009987692",
    "358731009987650",
    "358731009990167",
    "358731009989870",
    "358731009990142",
    "358731009987593",
    "358731009987619",
    "358731009987684",
    "358731009987726",
    "358731009988849",
    "358731009990183",
    "358731009987676",
    "358731009987718",
    "358731009987734",
    "358731009988757",
    "358731009988856",
    "358731009989946",
    "358731009989912",
    "358731009989920",
    "358731009987668",
    "358731009990597",
    "358731009990340",
    "358731009990209",
    "358731009987817",
    "358731009987825",
    "358731009987791",
    "358731009987833",
    "358731009990282",
    "358731009987585",
    "358731009985761",
    "358731009987163",
    "358731009988799",
    "358731009988773",
    "358731009988765",
    "358731009988823",
    "358731009988781",
    "358731009987460",
    "358731009986140",
    "358731009985993",
    "358731009987742",
    "358731009990274",
    "358731009990258",
    "358731009990233",
    "358731009990589",
    "358731009987759",
    "358731009987809",
    "358731009987767",
    "358731009987601",
    "358731009987577",
    "358731009986082",
    "358731009986272",
    "358731009986587",
    "358731009985969",
    "358731009986009",
    "358731009985951",
    "358731009986041",
    "358731009986033",
    "358731009985910",
    "358731009985795",
    "358731009986231",
    "358731009986298",
    "358731009986181",
    "358731009986314",
    "358731009985902",
    "358731009985936",
    "358731009985894",
    "358731009990571",
    "358731009986108",
    "358731009986116",
    "358731009986306",
    "358731009986249",
    "358731009986199",
    "358731009986264",
    "358731009986595",
    "358731009986132",
    "358731009986660",
    "358731009985977",
    "358731009986124",
    "358731009986173",
    "358731009986215",
    "358731009985050",
    "358731009986611",
    "358731009985779",
    "358731009986207",
    "358731009986280",
    "358731009987841",
    "358731009987486",
    "358731009986603",
    "358731009987346",
    "358731009990605",
    "358731009990696",
    "358731009990555",
    "358731009990779",
    "358731009990712",
    "358731009990670",
    "358731009990639",
    "358731009987437",
    "358731009990332",
    "358731009990621",
    "358731009989045",
    "358731009989151",
    "358731009992056",
    "358731009992213",
    "358731009991926",
    "358731009991801",
    "358731009992205",
    "358731009992049",
    "358731009992031",
    "358731009991991",
    "358731009992015",
    "358731009988435",
    "358731009988476",
    "358731009990753",
    "358731009988427",
    "358731009989243",
    "358731009988401",
    "358731009990803",
    "358731009992098",
    "358731009988443",
    "358731009988617",
    "358731009990373",
    "358731009988377",
    "358731009990654",
    "358731009988500",
    "358731009989987",
    "358731009988641",
    "358731009990035",
    "358731009990134",
    "358731009989979",
    "358731009989938",
    "358731009989524",
    "358731009990613",
    "358731009989599",
    "358731009989557",
    "358731009989573",
    "358731009989482",
    "358731009989953",
    "358731009989516",
    "358731009990043",
    "358731009990688",
    "358731009990381",
    "358731009989185",
    "358731009990787",
    "358731009990563",
    "358731009990316",
    "358731009990704",
    "358731009985068",
    "358731009990662",
    "358731009989227",
    "358731009985449",
    "358731009988369",
    "358731009985530",
    "358731009984970",
    "358731009985431",
    "358731009985498",
    "358731009985415",
    "358731009990514",
    "358731009985175",
    "358731009990498",
    "358731009985480",
    "358731009985506",
    "358731009985399",
    "358731009987148",
    "358731009985746",
    "358731009985308",
    "358731009984996",
    "358731009985423",
    "358731009985332",
    "358731009990464",
    "358731009985365",
    "358731009985407",
    "358731009985472",
    "358731009985589",
    "358731009985159",
    "358731009985548",
    "358731009985720",
    "358731009984830",
    "358731009985076",
    "358731009985233",
    "358731009985126",
    "358731009985282",
    "358731009985555",
    "358731009985167",
    "358731009985043",
    "358731009990415",
    "358731009984806",
    "358731009984749",
    "358731009984848",
    "358731009985084",
    "358731009985373",
    "358731009987080",
    "358731009985290",
    "358731009990738",
    "358731009990456",
    "358731009985241",
    "358731009985258",
    "358731009985100",
    "358731009985191",
    "358731009988294",
    "358731009992502",
    "358731009992411",
    "358731009991819",
    "358731009992775",
    "358731009992437",
    "358731009992528",
    "358731009992379",
    "358731009992841",
    "358731009992387",
    "358731009992460",
    "358731009992593",
    "358731009992486",
    "358731009992494",
    "358731009992395",
    "358731009992585",
    "358731009992510",
    "358731009992577",
    "358731009992403",
    "358731009992569",
    "358731009992429",
    "358731009992551",
    "358731009992478",
    "358731009992700",
    "358731009992627",
    "358731009992742",
    "358731009992635",
    "358731009992452",
    "358731009992601",
    "358731009992684",
    "358731009992676",
    "358731009992734",
    "358731009992825",
    "358731009992809",
    "358731009984913",
    "358731009992668",
    "358731009992791",
    "358731009992783",
    "358731009992833",
    "358731009992692",
    "358731009992817",
    "358731009983741",
    "358731009988880",
    "358731009988864",
    "358731009983766",
    "358731009984855",
    "358731009988872",
    "358731009992726",
    "358731009990647",
    "358731009990001",
    "358731009988997",
    "358731009988732",
    "358731009988914",
    "358731009989672",
    "358731009985639",
    "358731009988955",
    "358731009988906",
    "358731009988898",
    "358731009989698",
    "358731009988922",
    "358731009989797",
    "358731009985704",
    "358731009989078",
    "358731009988724",
    "358731009988807",
    "358731009987783",
    "358731009987775",
    "358731009989771",
    "358731009990357",
    "358731009990290",
    "358731009989003",
    "358731009985670",
    "358731009985654",
    "358731009988815",
    "358731009990266",
    "358731009989862",
    "358731009985688",
    "358731009988740",
    "358731009986025",
    "358731009985928",
    "358731009988831",
    "358731009989789",
    "358731009990530",
    "358731009992650",
    "358731009992718",
    "358731009989615",
    "358731009992643",
    "358731009986017",
    "358731009987445",
    "358731009989847",
    "358731009985944",
    "358731009991413",
    "358731009991421",
    "358731009991538",
    "358731009991470",
    "358731009991603",
    "358731009991710",
    "358731009991611",
    "358731009991736",
    "358731009991504",
    "358731009991686",
    "358731009989532",
    "358731009989623",
    "358731009989391",
    "358731009989383",
    "358731009989458",
    "358731009989474",
    "358731009989409",
    "358731009989490",
    "358731009989649",
    "358731009989367",
    "358731009991314",
    "358731009991397",
    "358731009989565",
    "358731009991447",
    "358731009991520",
    "358731009989581",
    "358731009989508",
    "358731009991348",
    "358731009991744",
    "358731009991496",
    "358731009989326",
    "358731009989300",
    "358731009989607",
    "358731009989425",
    "358731009989631",
    "358731009989417",
    "358731009989334",
    "358731009989375",
    "358731009989318",
    "358731009989433",
    "358731009990399",
    "358731009989839",
    "358731009989664",
    "358731009989680",
    "358731009989854",
    "358731009989748",
    "358731009990308",
    "358731009989706",
    "358731009989722",
    "358731009989805",
    "358731009992114",
    "358731009991827",
    "358731009991918",
    "358731009991884",
    "358731009992130",
    "358731009992361",
    "358731009991835",
    "358731009992106",
    "358731009991231",
    "358731009992064",
    "358731009989086",
    "358731009989656",
    "358731009989466",
    "358731009989284",
    "358731009989441",
    "358731009989201",
    "358731009989821",
    "358731009989037",
    "358731009989110",
    "358731009989144",
    "358731009991868",
    "358731009992270",
    "358731009992338",
    "358731009992288",
    "358731009992312",
    "358731009992262",
    "358731009992197",
    "358731009992296",
    "358731009992171",
    "358731009992320",
    "358731009992072",
    "358731009991876",
    "358731009991975",
    "358731009991892",
    "358731009992353",
    "358731009991900",
    "358731009991850",
    "358731009992007",
    "358731009991983",
    "358731009991843",
    "358731009992304",
    "358731009988385",
    "358731009992122",
    "358731009992163",
    "358731009992346",
    "358731009991959",
    "358731009991967",
    "358731009992155",
    "358731009992254",
    "358731009991942",
    "358731009988666",
    "358731009988716",
    "358731009988658",
    "358731009988682",
    "358731009988633",
    "358731009992239",
    "358731009988690",
    "358731009992148",
    "358731009988708",
    "358731009988351",
    "358731009983725",
    "358731009984103",
    "358731009985316",
    "358731009983659",
    "358731009983683",
    "358731009984160",
    "358731009983691",
    "358731009984657",
    "358731009985019",
    "358731009985134",
    "358731009988419",
    "358731009984640",
    "358731009988492",
    "358731009988484",
    "358731009988625",
    "358731009983667",
    "358731009984723",
    "358731009988450",
    "358731009988518",
    "358731009990019",
    "358731009983477",
    "358731009984137",
    "358731009984731",
    "358731009983584",
    "358731009983519",
    "358731009986413",
    "358731009986801",
    "358731009986090",
    "358731009986793",
    "358731009987049",
    "358731009986074",
    "358731009985878",
    "358731009984012",
    "358731009983972",
    "358731009984004",
    "358731009983576",
    "358731009990027",
    "358731009987015",
    "358731009986769",
    "358731009986553",
    "358731009986561",
    "358731009986694",
    "358731009986827",
    "358731009985886",
    "358731009985837",
    "358731009985829",
    "358731009986066",
    "358731009986447",
    "358731009985985",
    "358731009986546",
    "358731009986439",
    "358731009986819",
    "358731009986579",
    "358731009986850",
    "358731009983469",
    "358731009983493",
    "358731009986058",
    "358731009986330",
    "358731009990365",
    "358731009985845",
    "358731009986686",
    "358731009986512",
    "358731009986876",
    "358731009986918",
    "358731009986892",
    "358731009986371",
    "358731009986405",
    "358731009986884",
    "358731009986157",
    "358731009986462",
    "358731009986355",
    "358731009986843",
    "358731009986983",
    "358731009986504",
    "358731009986868",
    "358731009986652",
    "358731009986470",
    "358731009986637",
    "358731009986645",
    "358731009986165",
    "358731009984715",
    "358731009983949",
    "358731009984145",
    "358731009984202",
    "358731009984251",
    "358731009984418",
    "358731009983998",
    "358731009984178",
    "358731009983931",
    "358731009984269",
    "358731009984061",
    "358731009984194",
    "358731009984228",
    "358731009984368",
    "358731009984434",
    "358731009984319",
    "358731009984301",
    "358731009983550",
    "358731009984210",
    "358731009984186",
    NULL
};

int find_imei(const char **imeis, const char *imei)
{
    const char **iter;

    iter = imeis;

    while (*iter) {
        if (!strcmp(*iter, imei))
            return iter-imeis;

        iter++;
    }

    return -1;
}

class FixBdaddr_Private
{
public:
    QListWidget *m_list;
    QString m_imei;
    QWaitWidget *m_waitWidget;
};

FixBdaddr::FixBdaddr( QWidget* parent, Qt::WFlags fl )
:   QDialog( parent, fl )
{
    setWindowTitle(tr("Fix BT Address"));

    m_data = new FixBdaddr_Private;
    m_data->m_waitWidget = 0;

    QVBoxLayout* vbLayout = new QVBoxLayout(this);
    vbLayout->setMargin(0);
    vbLayout->setSpacing(0);

    m_data->m_list = new QListWidget(this);

    connect(m_data->m_list, SIGNAL(itemActivated(QListWidgetItem*)),
            this, SLOT(accept()));

    QListWidgetItem *item;
    item = new QListWidgetItem(option1, m_data->m_list);
    m_data->m_list->setCurrentItem(item);

    item = new QListWidgetItem(option2, m_data->m_list);

    m_data->m_list->setSelectionMode(QAbstractItemView::SingleSelection);
    m_data->m_list->setFrameStyle(QFrame::NoFrame);
    vbLayout->addWidget(m_data->m_list);

    QTelephonyConfiguration *config
            = new QTelephonyConfiguration( "modem" );   // No tr
    connect( config, SIGNAL(notification(QString,QString)),
             this, SLOT(configValue(QString,QString)) );
    config->request( "serial" );            // No tr
}

FixBdaddr::~FixBdaddr()
{
    delete m_data;
}

void FixBdaddr::configValue(const QString &key, const QString &value)
{
    if ( key == "serial" ) {   // No tr
        m_data->m_imei = value;
        if (m_data->m_waitWidget)
            m_data->m_waitWidget->hide();
    }
}

int set_bdaddr(const char *value)
{
    char bdaddr[6];
    unsigned int tmp[6];

    sscanf(value, "%02x:%02x:%02x:%02x:%02x:%02x", &tmp[0], &tmp[1], &tmp[2],
           &tmp[3], &tmp[4], &tmp[5]);

    for (int i = 0; i < 6; i++) {
        bdaddr[i] = tmp[i];
    }

    int fd = open("/dev/docparatable", O_RDONLY);
    if (fd < 0) {
        return 1;
    }

    if (ioctl(fd, DOCPTSETBTMACADDR, bdaddr) < 0) {
        close(fd);
        return 1;
    }

    close(fd);

    return 0;
}

void FixBdaddr::accept()
{
    if (m_data->m_imei.isEmpty()) {
        m_data->m_waitWidget = new QWaitWidget(this);
        m_data->m_waitWidget->setExpiryTime( 5000 );
        m_data->m_waitWidget->setCancelEnabled(true);
        m_data->m_waitWidget->setText( tr("Obtaining IMEI") );
        m_data->m_waitWidget->show();

        if (m_data->m_imei.isEmpty()) {
            QMessageBox::critical(this, tr("Change Bluetooth Address"),
                                  tr("Could not obtain IMEI, Bluetooth Address was NOT changed."));
            return;
        }
    }

    qLog(Bluetooth) << "Changing Bluetooth Address - IMEI: " << m_data->m_imei;

    if (m_data->m_list->currentItem()->text() == option2) {
        char buf[] = "AC:DE:48:00:00:00";
        int serial = m_data->m_imei.mid(8, 6).toInt();
        char subserial[6];
        snprintf(subserial, 6, "%5X", serial);
        subserial[5] = '\0';

        buf[10] = subserial[0];
        buf[12] = subserial[1];
        buf[13] = subserial[2];
        buf[15] = subserial[3];
        buf[16] = subserial[4];

        qLog(Bluetooth) << "Changing address to: " << buf;

        if (set_bdaddr(buf) != 0) {
            QMessageBox::critical(this, tr("Change Bluetooth Address"),
                                  tr("Could not write new device address."));
            return;
        }

        QMessageBox::information(this, tr("Change Bluetooth Address"),
                                 tr("Bluetooth Address changed to: ") + QString(buf) + ".  " +
                                         tr("Please reboot the device for changes to take effect"));
    }
    else if (m_data->m_list->currentItem()->text() == option1) {
        // Yuhuatel gave us an address block for DVT3 devices of
        // 00:19:65:00:08:01-00:19:65:00:08:64
        // Which is exactly 100 numbers
        // Only the last byte is changing
        char buf[] = "00:19:65:00:08:00";

        // For DVT4 devices, the block of addresses is:
        // 001965040000-0019650404B0
        int offset = 1;

        int position = find_imei(imeis, m_data->m_imei.toLatin1().constData());

        if (position != -1) {
            char tmp[3];
            snprintf(tmp, 3, "%02X", offset+position);
            buf[15] = tmp[0];
            buf[16] = tmp[1];
        }
        else {
            position = find_imei(imeisdvt4, m_data->m_imei.toLatin1().constData());

            if (position == -1) {
                QMessageBox::critical(this, tr("Change Bluetooth Address"),
                                    tr("Could not find your IMEI in the database.  Please contact qt-support@nokia.com"));
                return;
            }

            char tmp[5];
            snprintf(tmp, 5, "%04X", offset+position);
            buf[9] = '0';
            buf[10] = '4';
            buf[12] = tmp[0];
            buf[13] = tmp[1];
            buf[15] = tmp[2];
            buf[16] = tmp[3];
        }

        qLog(Bluetooth) << "Changing address to: " << buf;

        if (set_bdaddr(buf) != 0) {
            QMessageBox::critical(this, tr("Change Bluetooth Address"),
                                  tr("Could not write new device address."));
            return;
        }

        QMessageBox::information(this, tr("Change Bluetooth Address"),
                                 tr("Bluetooth Address changed to: ") + QString(buf) + ".  " +
                                         tr("Please reboot the device for changes to take effect"));
    }

    QDialog::accept();
}
